<?php
namespace apexl;

use n1ghteyes\apicore\client;

/**
 * Simple clockify config wrapper for the API Core class as Clockify APIs have a terrible structure.
 */
class clockify{

    //Base values
    protected $apiKey;
    protected $baseUrl = "api.clockify.me";
    protected $reportsUrl = "reports.api.clockify.me";
    protected $timeOffUrl = "pto.api.clockify.me";

    //API Core
    protected $api;

    //request values
    protected $userId;
    protected $workspaceId;

    public function __construct($apiKey)
    {
        $this->apiKey = $apiKey;
        $this->api = new client();
        $this->api->setVersion('v1', false);
        $this->api->setBodyFormat('json');
        $this->api->auth('X-Api-Key', $this->apiKey, 'header');
        //set up defaults
    }

    public function setBaseUrl($baseUrl){
        $this->baseUrl = $baseUrl;
        return $this;
    }

    public function setReportsURL($reportsUrl){
        $this->reportsUrl = $reportsUrl;
        return $this;
    }

    public function setTimeOffUrl($timeOffUrl){
        $this->timeOffUrl = $timeOffUrl;
        return $this;
    }

    /**
     * If we're doing this then we can set the base URL to /workspaces
     * @param $workspace
     * @return $this
     */
    public function setWorkspace($workspaceId){
        $this->workspaceId = $workspaceId;
        $this->api->setBasePath('api/v1/workspaces/'.$workspaceId);
        return $this;
    }

    /**
     * Magic __get function for setting the base path based on request.
     * @param string $name
     * @return $this|mixed
     */
    public function __get($name)
    {
        switch (strtolower($name)) {
            case 'reports': //We're making a query to reports so make sure we set that base URL.
                $this->api->setServer($this->reportsUrl);
                $this->api->setBasePath('v1');
                break;
            case 'policies': //These are timeOff calls.
            case 'balance':
            case 'requests':
                $this->api->setServer($this->timeOffUrl);
                $this->api->setBasePath('v1');
                break;
            default:
                $this->api->setServer($this->baseUrl);
                $this->api->setBasePath('api/v1');
        }
        $this->api->__get($name);
        return $this;
    }

    public function __call($name, $arguments){
        //run a method check.
        if(method_exists($this->api, $name)){
            return $this->api->$name(...$arguments);
        }
        //no method? hit __call();
        return $this->api->__call($name, $arguments);
    }
}
