<?php

namespace apexl;

use n1ghteyes\apicore\client;

class ConvertKit extends client
{
    protected string $apiSecret;

    public function __construct()
    {
        parent::__construct();

        $this->setServer('api.convertkit.com');
        $this->setBasePath('v3');
        $this->setBodyFormat('json');
    }

    public function setApiSecret(string $secret): ConvertKit
    {
        $this->apiSecret = $secret;

        return $this;
    }

    public function __call($name, $arguments)
    {
        //always add the api secret to the request.
        if ($arguments[0] ?? false) {
            $arguments[0]['api_secret'] = $this->apiSecret;
        } else {
            $arguments[] = ['api_secret' => $this->apiSecret];
        }

        return parent::__call($name, $arguments);
    }
}
