<?php

namespace apexl\entityCore\interfaces;

use apexl\Io\dto\EntityField;
use apexl\Io\exceptions\RecordNotFoundException;
use apexl\Vault\interfaces\operators;

interface EntityOperatorInterface
{
    /**
     * @throws RecordNotFoundException
     */
    public function load(int|string $id, bool $skipAccessCheck = false): array;

    /**
     * @throws RecordNotFoundException
     */
    public function loadBy(string $field, mixed $value, bool $skipAccessCheck = false): array;

    public function loadMultiple(
        array $conditions = [],
        array $orderBy = [],
        ?int $limit = null,
        ?int $offset = null,
    ): array;

    public function delete(int|string $id): operators;

    /**
     * @return EntityField[]
     */
    public function entityFields(): array;

}
