<?php

declare(strict_types=1);

namespace apexl\entityCore\enums;

enum Casts
{
    case BOOLEAN;
    case BOOL;
    case INTEGER;
    case INT;
    case FLOAT;
    case DOUBLE;
    case STRING;
    case ARRAY;
    case OBJECT;
    case NULL;
    case DATETIME;
    case DATETIME_STAMP;
    case SERIALIZE;

    public function getType(): string
    {
        return match ($this) {
            Casts::DATETIME_STAMP => 'int',
            default => strtolower($this->name),
        };
    }
}
