<?php declare(strict_types=1);

namespace apexl\entityCore\helpers;

use apexl\Vault\enums\WhereType;

class Condition
{
    public static function isNull(string $column): array
    {
        return [$column, null, 'IS NULL'];
    }

    public static function notNull(string $column): array
    {
        return [$column, null, 'IS NOT NULL'];
    }

    public static function equals(string $column, int|string $value): array
    {
        return [$column, $value, '='];
    }

    public static function notEquals(string $column, int|string $value): array
    {
        return [$column, $value, '!='];
    }

    public static function in(string $column, array $in): array
    {
        return [$column, $in, 'IN'];
    }

    public static function notIn(string $column, array $in): array
    {
        return [$column, $in, 'NOT IN'];
    }

    public static function greaterThan(string $column, int|string $than): array
    {
        return [$column, $than, '>'];
    }

    public static function lessThan(string $column, int|string $than): array
    {
        return [$column, $than, '<'];
    }

    public static function greaterThanOrEqual(string $column, int|string $than): array
    {
        return [$column, $than, '>='];
    }

    public static function lessThanOrEqual(string $column, int|string $than): array
    {
        return [$column, $than, '<='];
    }

    public static function or(array $condition): array
    {
        return [
            ...$condition,
            WhereType::OR,
        ];
    }
}
