<?php

declare(strict_types=1);

namespace apexl\entityCore\collections;

use apexl\Io\includes\Entity;
use Arrayy\Arrayy;
use Arrayy\Collection\AbstractCollection;
use Exception;

/**
 * @extends  AbstractCollection<array-key,Entity>
 */
class EntityCollection extends AbstractCollection
{
    /**
     * @throws Exception
     */
    public static function loadMultiple(
        array $conditions = [],
        array $orderBy = [],
        $limit = false,
        $offset = false,
    ): static {
        $instance = new static();
        $entity = new ($instance->getType())();

        return $instance->createFromArray(
            $entity->loadMultiple(
                $conditions,
                $orderBy,
                $limit,
                $offset
            )
        );
    }

    public function getType(): string
    {
        return Entity::class;
    }

    public function pluck(string $field): Arrayy
    {
        return Arrayy::createFromObject($this->map(fn(Entity $entity) => $entity->{$field}));
    }
}
