<?php

declare(strict_types=1);

namespace apexl\entityCore\services;

use apexl\Io\includes\System;
use Money\Currency;

final readonly class CurrencyFactory
{

    public function currency(string $code): Currency
    {
        return System::makeRegisteredService(Currency::class, [
            'code' => $code,
        ]);
    }
}