##Proton API Entity Persistor

This class is designed to take the complexity out of managing comminication with the Proton API.

####Installation

Install with composer. The composer.json file contains a non-standard repository that includes an agnostic API class (guzzle wrapper). Issues with this class can be logged here: https://github.com/N1ghteyes/apicore
```bash
composer install
```

####Configuration

Configuration is provided by a json file, the file path to which must be defined as a contstant
```php
define('PROTON_API_CONFIG_FILE', __DIR__.'/config.json');
``` 
The operating environment can either be defined as a constant or on the config file itself.
```php
define('PROTON_API_ENVIRONMENT', 'uat');
```
The config file itself should follow this structure:
```json
{
  "protonAuthHeader": "Ocp-Apim-Subscription-Key",
  "live": {
    "server": "proton.azure-api.net",
    "version": "v2",
    "static_referencesToken": "...",
    "sitesToken": "...",
    "hrToken": "..."
  },
  "uat": {
    "...": "..."
  },
  "dev": {
    "...": "..."
  }
}
```

You can add any number of additional config items, these will be accessable in the config class without any need for additional coding. For example, new environments or new access tokens.

####Using entities

Using entities is as simple as this:

```php
$entity = new taskEntity();
```

You can load an existing entity by using the load() method and passing the entity primary id value (usually the 'id' field)

```php
$task->load($id);
```

Saving an entity is just as simple.

```php
//The entity is only saved if a property has been updated or its a new record.
$task->save();
//force the entity to update even if no changed have been made
$task->save(TRUE);
```

Delete an entity:

```php
$task->delete();
```

You can access or set any field (property) you like simply by requesting or setting a value.

```php
//Get the task Time
$time = $task->Time;

//Set the task time
$task->Time = "12:00";

//set a new property that doesn't exist
$task->MyProp = 'Something silly';
```

####Creating a new entity class

Creating a new entity class is simple. These should be stored in /src/protonPL/entities to be PSR-4 compliant and correctly autoload.

```php
namespace zing\protonPL\entities;
use zing\protonPL\core\entity;

class MyEntity extends entity{

function __construct($entity = FALSE)
    {
        parent::__construct();
        $this->data = !empty($entity) ? $entity : [];
    }
    
    /**
    * Include all required abstract methods here. See taskEntity for an examnple
    */
}
```

To use your entity, simply add in a use statement to your project, and instantiate it. Your new entity will automatically be able to save(), update(), load() and delete()

```php
use zing\protonPL\entities\MyEntity;

$myentity = new MyEntity();

//Load
$myentity->load($id);
//update / create
$myentity->save();
//delete
$myentity->delete();
```

####Add a new endpoint call.

In some instances, it may be required that the API call additional URIs for specific verbs. For example, in the Opportunity API there are a number of additional endpoints.

New methods for these trivial to add, and can be done so in the entity class as follows.

First, we need to add the request to the mapper. The modifyMapper method is always required, even if it does nothing - however we need it to do this. 
```php
//add a new route.
//Format $this->requestMap[{HTTP_VERB}][{Method}] = $routeArgs[];
public function modifyMapper($method, $verb)
    {
        //Here we use the GET verb, specify the count function and return
        //the entity type as the first path element and 'count' as the second.
        $this->requestMap['GET']['count'] = [$this->getEntityType(), 'count'];
    }
```

Next we need to add a method to the entity to call count() on the persistor.

```php
public function groupCount($query = []){
        //make use of the __call magic method on the persistor to call new end points.
        //the name of the method is the endpoint, first argument is the HTTP verb, second is anything to pass as a query or body data
        return $this->persistor->count('GET', $query);
    }
```

The new method can then be accessed directly:

```php
$Opp = new oppertunity();
var_dump($Opp->groupCount());
```