<?php

namespace apexl\gocardless;

use apexl\hashing\Hash;
use GoCardlessPro\Client as GoCardless;
class Client{
    protected $accessToken;
    protected $gocardless;

    public function __construct($accessToken, $env = 'sandbox')
    {
        $this->accessToken = $accessToken;
        $environment = $env == 'sandbox' ? \GoCardlessPro\Environment::SANDBOX : \GoCardlessPro\Environment::LIVE;
        $this->gocardless = new GoCardless([
            'access_token' => $accessToken,
            'environment' => $environment
        ]);
    }

    public function getCustomers(){
        return $this->gocardless->customers()->list()->records;
    }

    public function startCreateCustomer($description, $customerInfo, $redirectUri, $userId){
        $redirectFlow = $this->gocardless->redirectFlows()->create([
            'params' => [
                "description" => $description,
                // Not the access token
                "session_token" => (string)$userId,
                "success_redirect_url" => $redirectUri,
                // Optionally, prefill customer details on the payment page
                "prefilled_customer" => $customerInfo
            ]
        ]);
        return $redirectFlow;
    }

    public function completeMandate($mandateId, $userId){
        $redirectFlow = $this->gocardless->redirectFlows()->complete(
            $mandateId, //The redirect flow ID from above.
            ["params" => ["session_token" => $userId]]
        );

        return $redirectFlow;
    }

    public function createMonthlySubscription($mandateId, $amountInPence, $subscriptionNumber, $dotm = "2", $curreny = 'GBP'){
        //we use Hash to generate a random unique string for this subscription/
        $hash = new Hash();
        $randomString = $hash->generateRandomHash();
        $subscription = $this->gocardless->subscriptions()->create([
            "params" => [
                "amount" => $amountInPence, // 15 GBP in pence
                "currency" => $curreny,
                "interval_unit" => "monthly",
                "day_of_month" => $dotm,
                "links" => [
                    "mandate" => $mandateId
                    // Mandate ID from the last section
                ],
                "metadata" => [
                    "subscription_number" => $subscriptionNumber
                ]
            ],
            "headers" => [
                "Idempotency-Key" => $randomString
            ]
        ]);

        return $subscription;
    }

    public function getSubscriptionStatus($subscriptionId){
        return $this->gocardless->subscriptions()->get($subscriptionId);
    }

    public function getRedirectFlowStatus($redirectId){
        return $this->gocardless->redirectFlows()->get($redirectId);
    }

    public function getAllMandates(){
        return $this->gocardless->subscriptions()->all();
    }

    public function getMandateStatus($mandateId){
        return $this->gocardless->mandates()->get($mandateId);
    }
}