<?php
namespace apexl\Io\middleware\goHaul;

use apexl\Io\modules\component\entities\componentEntity;
use apexl\Io\modules\menu\services\Menu;
use apexl\Io\modules\page\services\Page;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\services\Permissions;
use apexl\Io\services\pathUtility;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Server\MiddlewareInterface;
use Psr\Http\Server\RequestHandlerInterface as RequestHandler;

class goHaulController implements MiddlewareInterface
{
    protected $page;
    protected $permissions;
    protected $menu;
    protected $path;

    public function __construct(Page $page, Permissions $permissions, Menu $menu, pathUtility $path)
    {
        $this->page = $page;
        $this->permissions = $permissions;
        $this->menu = $menu;
        $this->path = $path;
    }

    public function process(Request $request, RequestHandler $handler): Response
    {
        if($this->path->getPath(0) !== 'login' && $this->path->getPath(0) !== 'forgot-password'){
            $uid = $request->getAttribute('user'); // set in an earlier middleware
            $user = new userEntity();
            $user->load($uid);

            $this->defaultPages($user);
        }
        return $handler->handle($request);
    }

    protected function defaultPages($user){
        //add the top bar
        //create the left sidebar component

        $leftSidebar = new componentEntity();
        $leftSidebar->name = 'TheLeftSidebar';
        $leftSidebar->classes = 'col-lg-2';
        $leftSidebar->addProperty('menuItems', $this->menu->getAllItemsAsMenu($user));

        //Populate the menu based on user permissions

        //add the page content Wrapper and add left sidebar to it.
        $globalWrapper = new componentEntity();
        $globalWrapper->name = 'ThePageContent';
        $globalWrapper->addComponent($leftSidebar);
        $this->page->addComponent($globalWrapper);


    }
}