<?php

namespace apexl\Io\modules\gohaul\controllers;

use apexl\Config\Singleton;
use apexl\EasyCSV;
use apexl\Io\includes\System;
use apexl\Io\includes\Utils;
use apexl\Io\modules\component\entities\componentEntity;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\fileField;
use apexl\Io\modules\gohaul\entities\importEntity;
use apexl\Io\modules\page\services\Page;
use apexl\Io\modules\user\entities\jobEntity;
use apexl\Io\modules\user\entities\purchaseOrderEntity;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\services\currentUser;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class AmazonJobImportController
{

    protected $page;
    /** @var userEntity */
    protected $currentUser;

    public function __construct(Page $page, currentUser $currentUser, Singleton $config)
    {
        $this->page = $page;
        $this->currentUser = $currentUser::getCurrentUser();
        $this->config = $config;
    }

    public function importPage(Request $request, Response $response){
        //First, we create the basic page
        $this->page->setMetaTitle('Import');
        $this->page->setMetaDescription('Import');

        //next add components, we assume the page already contains some components to only add to the content component.
        $contentTile = new componentEntity();
        $contentTile->name = 'GoHaulContentTile';
        $contentTile->props = (object)[
            "title" => 'Imports',
            "content" => "Please select the CSV file to import. As soon as its uploaded the import will run automatically",
        ];

        $form = new componentEntity();
        $form->name = 'Form';
        $form->addProperty('dataSrc', '/data/imports/importForm');

        $importList = new componentEntity();
        $importList->name = 'SimpleTable';
        $importList->classes = 'col-sm-12';
        $importList->addProperty('dataSrc', '/data/imports');


        $contentWrapper = new componentEntity();
        $contentWrapper->name = 'Content';
        $contentWrapper->classes = 'col-lg-10';
        $contentWrapper->addComponent($contentTile);
        $contentWrapper->addComponent($form);
        $contentWrapper->addComponent($importList);

        $globalWrapper = $this->page->getComponent('ThePageContent');
        $globalWrapper->addComponent($contentWrapper);
        $this->page->replaceComponent('ThePageContent', $globalWrapper);

        return System::asJson($response, $this->page->getPage());
    }

    public function dataImportListSimple($request, $response, $data){
        $imports = (new importEntity())->loadMultiple([], ['id']);
        $dataArray = [];
        foreach($imports as $import){
            $importData = (object)$import->getData();

            $user = new userEntity();
            $user->load($importData->created_user);

            $data = (object)[
                "Id" => $importData->ref,
                "Import Origin" => $importData->importOrigin,
                "File Path" => $importData->file_path,
                "Created" => $importData->created_date,
                "Created By" => $user->first_name.' '.$user->last_name,
            ];
            $dataArray[] = $data;
        }
        $tableHeader = isset($dataArray[0]) ? array_keys((array)$dataArray[0]) : [];
        return System::asJson($response, ['rows' => $dataArray, 'tableHeader' => $tableHeader]);
    }

    public function importForm($request, $response, $data){
        $form = new formEntity();
        $form->setId('managePos');
        $form->setMethod('post');
        $form->setActionUrl($this->config->app->site->backend_domain.'/imports');

        $file = (new fileField('document'))->setLabel('File');
        $file->setFileSavePath($this->config->app->site->backend_domain.'/imports');
        $form->addField($file, 'Upload Import');

        return System::asJson($response, $form->getBuiltFormArray());
    }

    public function saveFile(Request $request, $response, $data){
        //get the uploaded file
        $uploadedFile = $request->getUploadedFiles();

        //move it to the import Dir
        $filename = Utils::moveUploadedFile('imports/amazon', $uploadedFile['file']);

        //load the file and process.
        $filePath = System::getBasePath().'/'.$this->config->app->fileUploadDirectory.'/imports/amazon/'. $filename;

        //create a new amazon import
        $amazon = new importEntity();
        $amazon->importOrigin = 'amazon';
        $amazon->file_path = $filePath;
        $amazon->created_date = date('Y-m-d H:i:s');
        $amazon->created_user = $this->currentUser->id;
        $amazon->franchise = $this->currentUser->franchise;
        $amazon->store();

        $csv = new EasyCSV();
        $csv->loadFromFile($filePath);
        $jobData = $csv->csvArray;

        foreach($jobData as $row){
            //Strip currency.
            if(!isset($row['estimatedcost'])){
                continue;
            }
            $priceParts = explode(' ', $row['estimatedcost']);
            list($location1, $location2) = explode('->', $row['facilitysequence']);

            //we'll need a po for this, so create it first.
            $po = new purchaseOrderEntity();
            $po->collection = $location1.' '.$row['stop1yardarrival'] ?? NULL;
            $po->delivery = $location2.' '.$row['stop2yardarrival'] ?? NULL;
            $po->our_price = array_shift($priceParts);

            $po->created_date = date('Y-m-d H:i:s');
            $po->created_user = $this->currentUser->id;
            $po->import_id = $amazon->id;

            if($po->isValid()) {
                $po->store();
            } else {
                return System::asJson($response, ['success' => 'false'], 400);
            }


            $jobEntity = new jobEntity();
            $jobEntity->company = 1126; //Amazon
            $jobEntity->vehicle_type = 4;
            $jobEntity->purchase_order = $po->ref;
            $jobEntity->cost = $po->our_price;
            $jobEntity->vrid = $row['vrid'];
            $jobDate = strtotime($row['cpt']);
            $jobEntity->job_date = date('Y-m-d', $jobDate);

            $jobEntity->location_1 = $location1;
            $jobEntity->location_2 = $location2;

            $jobEntity->created_date = date('Y-m-d H:i:s');
            $jobEntity->created_user = $this->currentUser->id;

            $jobEntity->notes = '';

            $jobEntity->import_id = $amazon->id;

            $jobEntity->store();
        }

        return System::asJson($response, ['success' => 'true', 'redirectTo' => '/imports']);
    }
}