<?php

namespace apexl\Io\modules\gohaul\controllers;

use apexl\Io\includes\countries;
use apexl\Io\includes\System;
use apexl\Io\modules\component\entities\componentEntity;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\checkboxField;
use apexl\Io\modules\formbuilder\includes\inputField;
use apexl\Io\modules\formbuilder\includes\selectField;
use apexl\Io\modules\page\services\Page;
use apexl\Io\modules\user\entities\companiesEntity;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\services\currentUser;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class companiesController{

    protected $page;
    /** @var userEntity */
    protected $currentUser;
    public function __construct(Page $page, currentUser $currentUser){
        $this->page = $page;
        $this->currentUser = $currentUser::getCurrentUser();
    }

    public function list(Request $request, Response $response, $args){
        //First, we create the basic page
        $this->page->setMetaTitle('View Jobs List');
        $this->page->setMetaDescription('A list of all created jobs.');

        //next add components, we assume the page already contains some components to only add to the content component.
        $contentTile = new componentEntity();
        $contentTile->name = 'GoHaulContentTile';
        $contentTile->props = (object)[
            "title" => 'Company Manager',
            "content" => "In here you can make changes to the companies. Remember any changes you make will update instantly on the website.",
            "help" => 'Please select the company from the list below you wish to update or create a new one.',
            "buttons" => [
                (object)[
                    "text" => 'Create New Company',
                    "href" => '/companies/create',
                    "button" => 'btn-primary'
                ]
            ]
        ];

        $filterForm = new componentEntity();
        $filterForm->name = 'FilterForm';
        $filterForm->addProperty('dataSrc', '/data/companies/filterForm');


        $DataTable = new componentEntity();
        $DataTable->name = 'DataTable';
        $DataTable->addProperty('dataSrc', '/data/companies/list');


        $contentWrapper = new componentEntity();
        $contentWrapper->name = 'Content';
        $contentWrapper->classes = 'col-lg-10';
        $contentWrapper->addComponent($contentTile);
        $contentWrapper->addComponent($filterForm);
        $contentWrapper->addComponent($DataTable);

        $globalWrapper = $this->page->getComponent('ThePageContent');
        $globalWrapper->addComponent($contentWrapper);
        $this->page->replaceComponent('ThePageContent', $globalWrapper);

        return System::asJson($response, $this->page->getPage());
    }

    public function view(Request $request, Response $response, $args){
        if(!isset($args['ref'])){
            return System::asJson($response, ['message' => '404 not found'], 404);
        }
        $company = new companiesEntity();
        $company->load($args['ref']);

        if(!isset($company->ref)){
            return System::asJson($response, ['message' => '404 not found'], 404);
        }

        //First, we create the basic page
        $this->page->setMetaTitle('View Company: '.$company->full_name);
        $this->page->setMetaDescription('View Company: '.$company->full_name);

        //next add components, we assume the page already contains some components to only add to the content component.
        $contentTile = new componentEntity();
        $contentTile->name = 'GoHaulContentTile';
        $contentTile->props = (object)[
            "title" => 'Company: '.$company->full_name,
            "content" => "",
            "buttons" => [
                (object)[
                    "text" => 'Edit This Company',
                    "href" => '/companies/'.$company->ref.'/edit',
                    "button" => 'btn-primary'
                ],
                (object)[
                    "text" => 'Companies List',
                    "href" => '/companies',
                    "button" => 'btn-secondary'
                ],
                (object)[
                    "text" => 'Delete This Company',
                    "href" => '/companies/'.$company->ref.'/delete',
                    "button" => 'btn-danger'
                ]
            ]
        ];

        $contentRows = [];
        $contentRows[] = ['Address', $company->address_1];
        $contentRows[] = ['', $company->address_2];
        $contentRows[] = ['', $company->city];
        $contentRows[] = ['', $company->state != '' ? $company->state : $company->postcode];
        $contentRows[] = ['', $company->country];
        $contentRows[] = ['Fax', $company->fax];

        $contentDetailsTable = new componentEntity();
        $contentDetailsTable->name = 'ContentTable';
        $contentDetailsTable->classes = 'col-md-3';
        $contentDetailsTable->title = 'Details';
        $contentDetailsTable->rows = $contentRows;

        $creditRemaining = $company->getOutstandingPos();

        $contentRows = [];
        $contentRows[] = ['On Stop', $company->on_stop ? 'Yes' : 'No'];
        $contentRows[] = ['Factored', $company->factored ? 'Yes': 'No'];
        $contentRows[] = ['Haulage Exchange', $company->haulage_exchange ? 'Yes' : 'No'];
        $contentRows[] = ['Credit Limit', '£'.number_format($company->credit_limit, 2)];
        $contentRows[] = ['Outstanding', '£'.number_format($creditRemaining, 2)];
        $contentRows[] = ['Remaining', '£'.number_format($company->credit_limit - $creditRemaining, 2)];
        $contentRows[] = ['VAT No.', $company->vat_no];

        $contentContactTable = new componentEntity();
        $contentContactTable->name = 'ContentTable';
        $contentContactTable->classes = 'col-md-3';
        $contentContactTable->title = 'Financial';
        $contentContactTable->rows = $contentRows;

        $contentRows = [];
        $contentRows[] = ['Customer', $company->type_customer ? 'Yes' : 'No'];
        $contentRows[] = ['Haulier', $company->type_haulier ? 'Yes' : 'No'];

        $contentRolesTable = new componentEntity();
        $contentRolesTable->name = 'ContentTable';
        $contentRolesTable->classes = 'col-md-3';
        $contentRolesTable->title = 'Roles';
        $contentRolesTable->rows = $contentRows;

        $createdBy = new userEntity();
        $createdBy->load($company->created_user);

        $modifiedBy = new userEntity();
        $modifiedBy->load($company->modified_user);

        $contentRows = [];
        $contentRows[] = ['Created By', $createdBy->first_name.' '.$createdBy->last_name];
        $contentRows[] = ['Created Date', $company->created_date];
        $contentRows[] = ['Modified By', $modifiedBy->first_name.' '.$modifiedBy->last_name];
        $contentRows[] = ['Modified Date', $company->modified_date];

        $contentHistoryTable = new componentEntity();
        $contentHistoryTable->name = 'ContentTable';
        $contentHistoryTable->classes = 'col-md-3';
        $contentHistoryTable->title = 'History';
        $contentHistoryTable->rows = $contentRows;

        $rowWrapper = new componentEntity();
        $rowWrapper->name = 'RowWrapper';
        $rowWrapper->addComponent($contentDetailsTable);
        $rowWrapper->addComponent($contentContactTable);
        $rowWrapper->addComponent($contentRolesTable);
        $rowWrapper->addComponent($contentHistoryTable);

        //tabs
        $DataTable = new componentEntity();
        $DataTable->name = 'SimpleDataTable';
        $DataTable->basePath = '/jobs';
        $DataTable->addProperty('dataSrc', '/data/jobs/list?limit=20&offset=0&company='.$company->ref);

        $jobsTab = new componentEntity();
        $jobsTab->name = 'Tab';
        $jobsTab->label = 'Jobs';
        $jobsTab->id = 'Jobs';
        $jobsTab->active = true;
        $jobsTab->addComponent($DataTable);

        $DataTable = new componentEntity();
        $DataTable->name = 'SimpleDataTable';
        $DataTable->basePath = '/contacts';
        $DataTable->addProperty('dataSrc', '/data/contacts/list?company='.$company->ref);

        $contactsTab = new componentEntity();
        $contactsTab->name = 'Tab';
        $contactsTab->label = 'Contacts';
        $contactsTab->id = 'Contacts';
        $contactsTab->active = false;
        $contactsTab->addComponent($DataTable);

        $tabContainer = new componentEntity();
        $tabContainer->name = 'TabsContainer';
        $tabContainer->addComponent($jobsTab);
        $tabContainer->addComponent($contactsTab);

        $contentWrapper = new componentEntity();
        $contentWrapper->name = 'Content';
        $contentWrapper->classes = 'col-lg-10';
        $contentWrapper->addComponent($contentTile);
        $contentWrapper->addComponent($rowWrapper);
        $contentWrapper->addComponent($tabContainer);

        $globalWrapper = $this->page->getComponent('ThePageContent');
        $globalWrapper->addComponent($contentWrapper);
        $this->page->replaceComponent('ThePageContent', $globalWrapper);

        return System::asJson($response, $this->page->getPage());
    }

    public function create(Request $request, Response $response, $args){
        //First, we create the basic page
        $this->page->setMetaTitle('Create a Company');
        $this->page->setMetaDescription('Create a Company.');

        //next add components, we assume the page already contains some components to only add to the content component.
        $contentTile = new componentEntity();
        $contentTile->name = 'GoHaulContentTile';
        $contentTile->props = (object)[
            "title" => 'Create New Company',
            "content" => "Please enter the details of your new company and click \"Submit\".",
            "buttons" => [
                (object)[
                    "text" => 'Companies List',
                    "href" => '/companies',
                    "button" => 'btn-primary'
                ],
            ]
        ];

        $form = new componentEntity();
        $form->name = 'Form';
        $form->addProperty('dataSrc', '/data/companies/createForm');


        $contentWrapper = new componentEntity();
        $contentWrapper->name = 'Content';
        $contentWrapper->classes = 'col-lg-10';
        $contentWrapper->addComponent($contentTile);
        $contentWrapper->addComponent($form);

        $globalWrapper = $this->page->getComponent('ThePageContent');
        $globalWrapper->addComponent($contentWrapper);
        $this->page->replaceComponent('ThePageContent', $globalWrapper);

        return System::asJson($response, $this->page->getPage());
    }

    public function update(Request $request, Response $response, $args){
        //First, we create the basic page
        $company = new companiesEntity();
        $company->load($args['ref']);

        $this->page->setMetaTitle('Update a Company');
        $this->page->setMetaDescription('Create a Company.');

        //next add components, we assume the page already contains some components to only add to the content component.
        $contentTile = new componentEntity();
        $contentTile->name = 'GoHaulContentTile';
        $contentTile->props = (object)[
            "title" => 'Edit '.$company->full_name,
            "content" => "Please change the company as required and click \"Submit\".",
            "buttons" => [
                (object)[
                    "text" => 'Create New Company',
                    "href" => '/companies/create',
                    "button" => 'btn-primary'
                ],
                (object)[
                    "text" => 'Companies List',
                    "href" => '/companies',
                    "button" => 'btn-secondary'
                ],
            ]
        ];

        $form = new componentEntity();
        $form->name = 'Form';
        $form->addProperty('dataSrc', '/data/companies/'.$args['ref'].'/updateForm');


        $contentWrapper = new componentEntity();
        $contentWrapper->name = 'Content';
        $contentWrapper->classes = 'col-lg-10';
        $contentWrapper->addComponent($contentTile);
        $contentWrapper->addComponent($form);

        $globalWrapper = $this->page->getComponent('ThePageContent');
        $globalWrapper->addComponent($contentWrapper);
        $this->page->replaceComponent('ThePageContent', $globalWrapper);

        return System::asJson($response, $this->page->getPage());
    }

    public function filterForm(Request $request, Response $response, $args){
        $form = new formEntity();
        $form->setId('companyFilter');
        $form->setMethod('get');

        $form->addField((new checkboxField('customer'))->setLabel('Customer'), 'filter');
        $form->addField((new checkboxField('haulier'))->setLabel('Haulier'), 'filter');

        $form->addField((new inputField('location'))->setLabel('Location'), 'filter');
        $form->addField((new inputField('search'))->setLabel('Search'), 'filter');

        return System::asJson($response, $form->getBuiltFormArray());
    }

    public function manageForm(Request $request, Response $response, $args)
    {
        $company = FALSE;
        if (isset($args['ref'])) {
            $company = new companiesEntity();
            $company->load($args['ref']);
        }

        $form = new formEntity();
        $form->setId('manageCompany');
        $form->setMethod('post');
        $form->setActionUrl('companies');
        if($company){
            $form->setActionUrl('companies/'.$args['ref']);
        }

        //Details
        $fullname = (new inputField('full_name'))->setLabel('Full Name')->isRequired();
        if($company){
            $fullname->setValue($company->full_name);
        }
        $form->addField($fullname, 'details');

        $shortname = (new inputField('name'))->setLabel('Short Name')->isRequired();
        if($company){
            $shortname->setValue($company->name);
        }
        $form->addField($shortname, 'details');

        $division = (new inputField('division'))->setLabel('Division');
        if($company){
            $division->setValue($company->division);
        }
        $form->addField($division, 'details');

        $fax = (new inputField('fax'))->setLabel('Fax');
        if($company){
            $fax->setValue($company->fax);
        }
        $form->addField($fax, 'details');

        //Address
        $address1 = (new inputField('address_1'))->setLabel('Street')->isRequired();
        if($company){
            $address1->setValue($company->address_1);
        }
        $form->addField($address1, 'address');

        $address2 = (new inputField('address_2'));
        if($company){
            $address2->setValue($company->address_2);
        }
        $form->addField($address2, 'address');

        $city = (new inputField('city'))->setLabel('City/Town');
        if($company){
            $city->setValue($company->city);
        }
        $form->addField($city, 'address');

        $state = (new inputField('state'))->setLabel('State (USA Only) - 2 Char ISO Code');
        $state->field->maxlength = 2;
        if($company){
            $state->setValue($company->state);
        }
        $form->addField($state, 'address');

        $postcode = (new inputField('postcode'))->setLabel('Postcode');
        if($company){
            $postcode->setValue($company->postcode);
        }
        $form->addField($postcode, 'address');

        $countries = countries::getAllCountries();
        $countryOptions = [];
        foreach ($countries as $country)
        {
            $countryOptions[$country['key']] = $country['value'];
        }

        $country = (new selectField('country'))->addOptions($countryOptions)->setValue('GB')->setLabel('Country')->isRequired();
        if($company){
            $country->setValue($company->country);
        }
        $form->addField($country, 'address');

        //Financial
        $onStop = (new checkboxField('on_stop'))->setLabel('On Stop');
        if($company && $company->on_stop){
            $onStop->setValue($company->on_stop);
        }
        $form->addField($onStop, 'financial');

        $factored = (new checkboxField('factored'))->setLabel('Factored');
        if($company && $company->factored){
            $factored->setValue($company->factored);
        }
        $form->addField($factored, 'financial');

        $haulageExchange = (new checkboxField('haulage_exchange'))->setLabel('Haulage Exchange');
        if($company && $company->haulage_exchange){
            $haulageExchange->setValue($company->haulage_exchange);
        }
        $form->addField($haulageExchange, 'financial');

        $creditLimit = (new inputField('credit_limit'))->setLabel('Credit Limit');
        if($company){
            $creditLimit->setValue($company->credit_limit);
        }
        $form->addField($creditLimit, 'financial');

        $vatNo = (new inputField('vat_no'))->setLabel('VAT No.');
        if($company){
            $vatNo->setValue($company->vat_no);
        }
        $form->addField($vatNo, 'financial');

        //Types
        $customer = (new checkboxField('type_customer'))->setLabel('Customer');
        if($company && $company->type_customer){
            $customer->setValue($company->type_customer);
        }
        $form->addField($customer, 'types');

        $haulier = (new checkboxField('type_haulier'))->setLabel('Haulier');
        if($company && $company->type_haulier){
            $haulier->setValue($company->type_haulier);
        }
        $form->addField($haulier, 'types');

        return System::asJson($response, $form->getBuiltFormArray());
    }

    public function dataCompaniesList($request, $response, $data){
        $params = $request->getQueryParams();

        $limit = isset($params['limit']) && !empty($params['limit']) ? $params['limit'] : 0;
        $offset = isset($params['offset']) && !empty($params['offset']) ? $params['offset'] : 0;

        $filters = $this->buildFilterConditions($params);

        $companies = (new companiesEntity())->loadMultiple($filters, ['ref'], $limit, $offset);
        $totalResults = (new companiesEntity())->totalEntities();
        $totalPages = ceil (($totalResults/$params['limit']));
        $dataArray = [];
        foreach($companies as $job){
            $entityData = (object)$job->getData();
            $data = (object)[
                "Ref" => $entityData->ref,
                "Name" => $entityData->full_name,
                "City" => $entityData->city,
                "Credit limit" => $entityData->credit_limit,
                "Outstanding" => "",
                "Remaining" => "",
                "Exchange" => $entityData->haulage_exchange,
                "Customer" => $entityData->type_customer,
                "Haulier" => $entityData->type_haulier
            ];
            $dataArray[] = $data;
        }
        $tableHeader = isset($dataArray[0]) ? array_keys((array)$dataArray[0]) : [];
        return System::asJson($response, ['rows' => $dataArray, 'totalData' => $totalResults, 'totalPages' => $totalPages, 'tableHeader' => $tableHeader]);
    }

    public function jobList($request, $response, $data){

        return ;
    }

    public function contactList($request, $response, $data){

        return ;
    }

    public function createUpdate($request, $response, $data){
        $company = new companiesEntity();
        $body = $request->getParsedBody();
        if(isset($data['ref'])){
            $company->load($data['ref']);
        } else {
            $company->created_date = date('Y-m-d H:i:s');
            $company->created_user = $this->currentUser->id;
            $company->franchise = $this->currentUser->franchise;
        }

        $company->full_name = $body->full_name;
        $company->name = $body->name;
        $company->division = $body->division;
        $company->fax = $body->fax;

        $company->address_1 = $body->address_1;
        $company->address_2 = $body->address_2;
        $company->city = $body->city;
        $company->state = $body->state;
        $company->postcode = $body->postcode;
        $company->country = $body->country;

        $company->on_stop = !empty($body->on_stop) ? 1 : 0;
        $company->factored = !empty($body->factored) ? 1 : 0;
        $company->haulage_exchange = !empty($body->haulage_exchange) ? 1 : 0;

        $company->credit_limit = !empty($body->credit_limit) ? $body->credit_limit : 0;
        $company->vat_no = $body->vat_no;

        $company->type_customer = !empty($body->type_customer) ? 1 : 0;
        $company->type_haulier = !empty($body->type_haulier) ? 1 : 0;

        $company->modified_date = date('Y-m-d H:i:s');
        $company->modified_user = $this->currentUser->id;

        if($company->isValid()){
            $company->store();
            return System::asJson($response, ['success' => 'true', 'redirectTo' => '/companies']);
        }
        return System::asJson($response, ['success' => 'false'], 400);
    }

    public function deleteView($request, $response, $data){
        //First, we create the basic page
        $company = new companiesEntity();
        if(isset($data['ref'])){
            $company->load($data['ref']);

            $this->page->setMetaTitle('Delete a Company');
            $this->page->setMetaDescription('Delete a Company.');

            //next add components, we assume the page already contains some components to only add to the content component.
            $contentTile = new componentEntity();
            $contentTile->name = 'GoHaulContentTile';
            $contentTile->props = (object)[
                "title" => 'Delete Company',
                "content" => "Are you sure you want to delete this company (".$company->full_name.")?",
                "buttons" => [
                    (object)[
                        "text" => 'Confirm Delete',
                        "href" => '/companies/'.$company->ref,
                        "button" => 'btn-danger',
                        "type" => "delete"
                    ],
                ]
            ];

            $contentWrapper = new componentEntity();
            $contentWrapper->name = 'Content';
            $contentWrapper->classes = 'col-lg-10';
            $contentWrapper->addComponent($contentTile);

            $globalWrapper = $this->page->getComponent('ThePageContent');
            $globalWrapper->addComponent($contentWrapper);
            $this->page->replaceComponent('ThePageContent', $globalWrapper);

            return System::asJson($response, $this->page->getPage());
        } else {
            return System::asJson($response, ['success' => 'false'], 404);
        }
    }

    public function delete($request, $response, $data){
        (new companiesEntity())->delete($data['ref']);
        return System::asJson($response, ['success' => 'true', 'redirectTo' => '/companies']);
    }

    protected function buildFilterConditions($params){
        $filters = [];
        foreach($params as $param => $value){
            if($param == 'limit' || $param == 'offset' || $param == 'page' || empty($value)){
                continue;
            }
            switch($param){
                case 'search':
                    $filters['ref'] = ['ref', '%'.$value.'%', 'like', 'OR'];
                    $filters['name'] = ['full_name', '%'.$value.'%', 'like', 'OR'];
                    $filters['address_1'] = ['address_1', '%'.$value.'%', 'like', 'OR'];
                    $filters['city'] = ['city', '%'.$value.'%)', 'like', 'OR'];
                    break;
                case 'location':
                    $filters['city'] = ['city', $value];
                    break;
                case 'haulier':
                    $filters['haulier'] = ['type_haulier', 1];
                    break;
                case 'customer':
                    $filters['customer'] = ['type_customer', 1];
                    break;
            }
        }
        return $filters;
    }
}