<?php

namespace apexl\Io\modules\gohaul\controllers;

use apexl\Config\Singleton;
use apexl\Io\includes\System;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\checkboxField;
use apexl\Io\modules\formbuilder\includes\inputField;
use apexl\Io\modules\formbuilder\includes\textareaField;
use apexl\Io\modules\gohaul\entities\defectEntity;
use apexl\Io\modules\page\services\Page;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\services\currentUser;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class defectController {
    protected $page;
    /** @var userEntity */
    protected $currentUser;

    public function __construct(Page $page, currentUser $currentUser, Singleton $config)
    {
        $this->page = $page;
        $this->currentUser = $currentUser::getCurrentUser();
        $this->config = $config;
    }

    public function defectForm(Request $request, Response $response){
        $form = new formEntity();
        $form->setId('manageDefect');
        $form->setMethod('post');
        $form->setActionUrl('defects');

        $form->addField((new inputField('vehicle_no'))->setLabel('Vehicle No.')->isRequired(), 'details');
        $form->addField((new inputField('trailer_serial_no'))->setLabel('Trailer/Fleet Serial No.')->isRequired(), 'details');
        $form->addField((new inputField('odometer'))->setLabel('Odometer Reading')->isRequired(), 'details');

        $form->addField((new checkboxField('leaks'))->setLabel('Fuel / Oil leaks'), 'daily or shift check');
        $form->addField((new checkboxField('battery'))->setLabel('Battery security (condition)'), 'daily or shift check');
        $form->addField((new checkboxField('tyres'))->setLabel('Tyres / wheel and wheel fixing'), 'daily or shift check');
        $form->addField((new checkboxField('spray'))->setLabel('Spray suppression'), 'daily or shift check');
        $form->addField((new checkboxField('steering'))->setLabel('Steering'), 'daily or shift check');
        $form->addField((new checkboxField('security_load'))->setLabel('Security of load / Vehicle height'), 'daily or shift check');
        $form->addField((new checkboxField('visibility'))->setLabel('Mirrors / Glass / Visibility'), 'daily or shift check');
        $form->addField((new checkboxField('air'))->setLabel('Air build-up / Leaks'), 'daily or shift check');

        $form->addField((new checkboxField('lights'))->setLabel('Lights'), 'daily or shift check');
        $form->addField((new checkboxField('reflectors'))->setLabel('Reflectors / Markers'), 'daily or shift check');
        $form->addField((new checkboxField('indicators'))->setLabel('Indicators / Side repeaters'), 'daily or shift check');
        $form->addField((new checkboxField('wipers'))->setLabel('Wipers'), 'daily or shift check');
        $form->addField((new checkboxField('washers'))->setLabel('Washers'), 'daily or shift check');
        $form->addField((new checkboxField('horn'))->setLabel('Horn'), 'daily or shift check');
        $form->addField((new checkboxField('exhaust'))->setLabel('Excessive engine exhaust smoke'), 'daily or shift check');
        $form->addField((new checkboxField('adblue'))->setLabel('AdBlue if required'), 'daily or shift check');

        $form->addField((new checkboxField('brake_lines'))->setLabel('Brake lines *'), 'daily or shift check');
        $form->addField((new checkboxField('coupling_security'))->setLabel('Coupling security *'), 'daily or shift check');
        $form->addField((new checkboxField('electrical_connections'))->setLabel('Electrical Connections *'), 'daily or shift check');
        $form->addField((new checkboxField('brakes_abs_ebs'))->setLabel('Brakes inc. ABS/EBS'), 'daily or shift check');
        $form->addField((new checkboxField('security_body'))->setLabel('Security / Condition of body / wings'), 'daily or shift check');
        $form->addField((new checkboxField('reg_plates'))->setLabel('Registration plates'), 'daily or shift check');
        $form->addField((new checkboxField('cab_interior'))->setLabel('Cab interior / Seat belts'), 'daily or shift check');
        $form->addField((new checkboxField('warning_lamps'))->setLabel('Warning Lamps / MIL'), 'daily or shift check');

        $form->addField((new textareaField('defects'))->setLabel('REPORT DEFECTS HERE:'), 'summery');
        $form->addField((new inputField('reported_to'))->setLabel('Defects Reported to:'), 'summery');
        $form->addField((new checkboxField('no_defects'))->setLabel('Check if no defects found'), 'summery');

        $form->addField((new inputField('signature'))->setLabel('Driver\'s Signature'), 'summery');
        return System::asJson($response, $form->getBuiltFormArray());
    }

    public function defectList(Request $request, Response $response){
        $defects = (new defectEntity())->loadMultiple([], ['id']);
        $dataArray = [];
        foreach($defects as $defect){
            $defectData = (object)$defect->getData();
            $driver = new userEntity();
            $driver->load($defectData->driver_id);

            $data = (object)[
                "Id" => $defectData->ref,
                "Date" => date('d-m-Y h:i:s',$defectData->created),
                "Vehicle" => $defectData->vehicle_no,
                "Driver" =>  $driver->first_name . ' ' . $driver->last_name,
                "Defects" => $defectData->no_defects == 0 ? 'Yes' : 'No',
                "#" => (object)[
                    'href' => '/defect/'.$defectData->id, 'title' => '<button class="btn btn-success">View Defect <i class="fal fw fa-search"></i></button>',
                ]
            ];
            $dataArray[] = $data;
        }
        $tableHeader = isset($dataArray[0]) ? array_keys((array)$dataArray[0]) : [];
        return System::asJson($response, ['rows' => $dataArray, 'tableHeader' => $tableHeader]);
    }

    public function defectView(Request $request, Response $response){
        if(!isset($args['ref'])){
            return System::asJson($response, ['message' => '404 not found'], 404);
        }
        $job = new jobEntity();
        $job->load($args['ref']);

        if(!isset($job->ref)){
            return System::asJson($response, ['message' => '404 not found, job id '.$args['ref'].' is missing or malformed.'], 404);
        }

        $company = new companiesEntity();
        $company->load($job->company);

        //First, we create the basic page
        $this->page->setMetaTitle('Job #'.$job->ref.' for '.$company->name);
        $this->page->setMetaDescription('View a job');

        //next add components, we assume the page already contains some components to only add to the content component.
        $contentTile = new componentEntity();
        $contentTile->name = 'GoHaulContentTile';
        $contentTile->props = (object)[
            "title" => 'Job #'.$job->ref.' for '.$company->name,
            "content" => "",
            "buttons" => [
                (object)[
                    "text" => 'Edit This Job',
                    "href" => '/jobs/'.$job->ref.'/edit',
                    "button" => 'btn-primary'
                ],
                (object)[
                    "text" => 'Create Invoice',
                    "href" => '/jobs/'.$job->ref.'/invoice',
                    "button" => 'btn-primary'
                ],
                (object)[
                    "text" => 'Jobs List',
                    "href" => '/jobs',
                    "button" => 'btn-secondary'
                ],
                (object)[
                    "text" => 'Delete This job',
                    "href" => '/jobs/'.$job->ref.'/delete',
                    "button" => 'btn-danger'
                ]
            ]
        ];

        $vehicleType = new vehicleTypeEntity();
        $vehicleType->load($job->vehicle_type);

        $vehicle = new vehicleEntity();
        $vehicle->load($job->vehicle);

        $driver = new userEntity();
        $driver->load($job->driver);

        $purchaseOrder = new purchaseOrderEntity();
        $purchaseOrder->load($job->purchase_order);

        $contentRows = [];
        $contentRows[] = ['Company', (object)['href' => '/companies/'.$company->ref, 'title' => $company->full_name]];
        $contentRows[] = ['Purchase Order', (object)['href' => '/pos/'.$job->purchase_order, 'title' => $job->purchase_order]];
        $contentRows[] = ['Date', $job->job_date];
        $contentRows[] = ['Status', $job->status];

        $contentRows[] = ['Vehicle Type', $vehicleType->name];
        $contentRows[] = ['Vehicle Registration', $purchaseOrder->vehicle_registration];
        if($driver->ref) {
            $contentRows[] = ['Driver', $driver->first_name . ' ' . $driver->last_name];
        } else {
            $contentRows[] = ['Driver', ''];
        }
        $contentRows[] = ['Vehicle', $vehicle->registration ?? ''];

        $contentRows[] = ['Completed', $job->completed_date];
        $contentRows[] = ['Confirmed', $job->confirmed_date];
        $contentRows[] = ['Invoiced', $job->invoiced_date.' '.$job->invoice_no];

        $contentDetailsTable = new componentEntity();
        $contentDetailsTable->name = 'ContentTable';
        $contentDetailsTable->classes = 'col-md-12 col-lg-6 col-xl-4';
        $contentDetailsTable->title = 'Details';
        $contentDetailsTable->rows = $contentRows;

        $contentRows = [];
        $contentRows[] = [$job->location_1];
        $contentRows[] = [$job->location_2];
        $contentRows[] = [$job->location_3];
        $contentRows[] = [$job->location_4];

        $contentRows[] = ['Per Mile', $vehicleType->cost_per_mile.'p'];
        $contentRows[] = ['Actual', '£'.number_format($job->cost, 2)];

        $contentRows[] = ['Invoiced', $job->invoiced_amount];
        $contentRows[] = ['Paid', $job->amount_paid];
        $contentRows[] = ['Sync', ''];

        $contentContactTable = new componentEntity();
        $contentContactTable->name = 'ContentTable';
        $contentContactTable->classes = 'col-md-12 col-lg-6 col-xl-4';
        $contentContactTable->title = 'Financial';
        $contentContactTable->rows = $contentRows;

        $createdBy = new userEntity();
        $createdBy->load($job->created_user);

        $modifiedBy = new userEntity();
        $modifiedBy->load($job->modified_user);

        $contentRows = [];
        $contentRows[] = ['Created By', $createdBy->first_name.' '.$createdBy->last_name];
        $contentRows[] = ['Created Date', $job->created_date];
        $contentRows[] = ['Modified By', $modifiedBy->first_name.' '.$modifiedBy->last_name];
        $contentRows[] = ['Modified Date', $job->modified_date];

        $contentHistoryTable = new componentEntity();
        $contentHistoryTable->name = 'ContentTable';
        $contentHistoryTable->classes = 'col-md-12 col-lg-6 col-xl-4';
        $contentHistoryTable->title = 'History';
        $contentHistoryTable->rows = $contentRows;

        $contentRows = [];
        $contentRows[] = [$job->notes];

        $contentNotesTable = new componentEntity();
        $contentNotesTable->name = 'ContentTable';
        $contentNotesTable->classes = 'col-md-12';
        $contentNotesTable->rows = $contentRows;

        $form = new componentEntity();
        $form->name = 'Form';
        $form->classes = 'col-md-12';
        $form->addProperty('dataSrc', '/data/jobs/'.$job->ref.'/jobAttachmentsForm');

        $rowWrapper = new componentEntity();
        $rowWrapper->name = 'RowWrapper';
        $rowWrapper->addComponent($contentDetailsTable);
        $rowWrapper->addComponent($contentContactTable);
        $rowWrapper->addComponent($contentHistoryTable);

        $jobAttachment = new componentEntity();
        $jobAttachment->name = 'SimpleTable';
        $jobAttachment->classes = 'col-sm-12';
        $jobAttachment->addProperty('dataSrc', '/data/jobs/'.$job->ref.'/jobAttachmentsData');

        $attachmentTab = new componentEntity();
        $attachmentTab->name = 'Tab';
        $attachmentTab->label = 'Job Attachments';
        $attachmentTab->id = 'job_attachments';
        $attachmentTab->active = true;
        $attachmentTab->addComponent($jobAttachment);
        $attachmentTab->addComponent($form);

        $notesTab = new componentEntity();
        $notesTab->name = 'Tab';
        $notesTab->label = 'Notes';
        $notesTab->id = 'notes';
        $notesTab->active = false;
        $notesTab->addComponent($contentNotesTable);

        $tabContainer = new componentEntity();
        $tabContainer->name = 'TabsContainer';
        $tabContainer->addComponent($attachmentTab);
        $tabContainer->addComponent($notesTab);

        $contentWrapper = new componentEntity();
        $contentWrapper->name = 'Content';
        $contentWrapper->classes = 'col-lg-10';
        $contentWrapper->addComponent($contentTile);
        $contentWrapper->addComponent($rowWrapper);
        $contentWrapper->addComponent($tabContainer);

        $globalWrapper = $this->page->getComponent('ThePageContent');
        $globalWrapper->addComponent($contentWrapper);
        $this->page->replaceComponent('ThePageContent', $globalWrapper);

        return System::asJson($response, $this->page->getPage());
    }

    public function defectFormSave(Request $request, Response $response){
        $body = $request->getParsedBody();
        $defects = new defectEntity();
        $defects->created = time();
        $defects->driver_id = $this->currentUser->id;
        $defects->franchise = $this->currentUser->franchise;
        foreach($body as $field => $value){
            switch($field){
                case 'reported_to':
                case 'signature':
                case 'trailer_serial_no':
                case 'vehicle_no':
                    $defects->$field = $value ?? "";
                    break;
                default:
                    $defects->$field = !empty($value) ? (int)$value : 0;
                    break;
            }
        }
        $defects->store();
        return System::asJson($response, ["redirectTo" => "/"]);
    }
}