<?php

namespace apexl\Io\modules\gohaul\controllers;

use apexl\Config\Singleton;
use apexl\Io\includes\System;
use apexl\Io\includes\Utils;
use apexl\Io\modules\component\entities\componentEntity;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\inputField;
use apexl\Io\modules\page\services\Page;
use apexl\Io\modules\user\entities\attachmentEntity;
use apexl\Io\modules\user\entities\documentsEntity;
use apexl\Io\modules\user\entities\franchiseEntity;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\services\currentUser;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class documentsController{

    protected $page;
    /** @var userEntity */
    protected $currentUser;
    /** @var Singleton */
    protected $config;
    public function __construct(Page $page, currentUser $currentUser, Singleton $config){
        $this->page = $page;
        $this->currentUser = $currentUser::getCurrentUser();
        $this->config = $config;
    }

    public function list(Request $request, Response $response, $args){
        //First, we create the basic page
        $this->page->setMetaTitle('View Jobs List');
        $this->page->setMetaDescription('A list of all created jobs.');

        //next add components, we assume the page already contains some components to only add to the content component.
        $contentTile = new componentEntity();
        $contentTile->name = 'GoHaulContentTile';
        $contentTile->props = (object)[
            "title" => 'Document Manager',
            "content" => "In here you can make changes to the documents. Remember any changes you make will update instantly on the website.",
            "help" => 'Please select the document from the list below you wish to update or create a new one.',
            "buttons" => [
                (object)[
                    "text" => 'Create New Document',
                    "href" => '/documents/create',
                    "button" => 'btn-primary'
                ]
            ]
        ];

        $DataTable = new componentEntity();
        $DataTable->name = 'DataTable';
        $DataTable->addProperty('dataSrc', '/data/documents/list');


        $contentWrapper = new componentEntity();
        $contentWrapper->name = 'Content';
        $contentWrapper->classes = 'col-lg-10';
        $contentWrapper->addComponent($contentTile);
        $contentWrapper->addComponent($DataTable);

        $globalWrapper = $this->page->getComponent('ThePageContent');
        $globalWrapper->addComponent($contentWrapper);
        $this->page->replaceComponent('ThePageContent', $globalWrapper);

        return System::asJson($response, $this->page->getPage());
    }

    public function view(Request $request, Response $response, $args){
        if(!isset($args['ref'])){
            return System::asJson($response, ['message' => '404 not found'], 404);
        }
        $document = new documentsEntity();
        $document->load($args['ref']);

        if(!isset($document->ref)){
            return System::asJson($response, ['message' => '404 not found'], 404);
        }
        //First, we create the basic page
        $this->page->setMetaTitle('Document: '.$document->name);
        $this->page->setMetaDescription('Document: '.$document->name);

        //next add components, we assume the page already contains some components to only add to the content component.
        $contentTile = new componentEntity();
        $contentTile->name = 'GoHaulContentTile';
        $contentTile->props = (object)[
            "title" => $document->name,
            "content" => "",
            "buttons" => [
                (object)[
                    "text" => 'Edit This Document',
                    "href" => '/documents/'.$document->ref.'/edit',
                    "button" => 'btn-primary'
                ],
                (object)[
                    "text" => 'Document List',
                    "href" => '/documents',
                    "button" => 'btn-secondary'
                ],
                (object)[
                    "text" => 'Delete This Document',
                    "href" => '/documents/'.$document->ref.'/delete',
                    "button" => 'btn-danger'
                ]
            ]
        ];

        $downloadComponent = new componentEntity();
        $downloadComponent->name = 'DownloadButton';
        $downloadComponent->props = (object)[
            'ref' => $document->ref,
            'type' => 'documents',
        ];

        $contentRows = [];
        $contentRows[] = ['Collection', $document->name];
        $contentRows[] = ['Download', (object)[
            "component" => $downloadComponent->getData(),
        ]];
        $contentRows[] = ['Delete', (object)['href' => '/documents/'.$document->ref.'/delete?type=documents', 'title' => '<button class="btn btn-danger"><i class="fal fw fa-trash"></i></button>']];

        $contentDetailsTable = new componentEntity();
        $contentDetailsTable->name = 'ContentTable';
        $contentDetailsTable->classes = 'col-md-3';
        $contentDetailsTable->title = 'Details';
        $contentDetailsTable->rows = $contentRows;

        $contentRows = [];

        if(!empty($document->created_user)) {
            $createdBy = new userEntity();
            $createdBy->load($document->created_user);
            $contentRows[] = ['Created By', $createdBy->first_name . ' ' . $createdBy->last_name];
            $contentRows[] = ['Created Date', $document->created_date];
        }
        if(!empty($document->modified_user)) {
            $modifiedBy = new userEntity();
            $modifiedBy->load($document->modified_user);
            $contentRows[] = ['Modified By', $modifiedBy->first_name . ' ' . $modifiedBy->last_name];
            $contentRows[] = ['Modified Date', $document->modified_date];
        }

        $contentHistoryTable = new componentEntity();
        $contentHistoryTable->name = 'ContentTable';
        $contentHistoryTable->classes = 'col-md-3';
        $contentHistoryTable->title = 'History';
        $contentHistoryTable->rows = $contentRows;

        $rowWrapper = new componentEntity();
        $rowWrapper->name = 'RowWrapper';
        $rowWrapper->addComponent($contentDetailsTable);
        $rowWrapper->addComponent($contentHistoryTable);

        $contentWrapper = new componentEntity();
        $contentWrapper->name = 'Content';
        $contentWrapper->classes = 'col-lg-10';
        $contentWrapper->addComponent($contentTile);
        $contentWrapper->addComponent($rowWrapper);

        $globalWrapper = $this->page->getComponent('ThePageContent');
        $globalWrapper->addComponent($contentWrapper);
        $this->page->replaceComponent('ThePageContent', $globalWrapper);

        return System::asJson($response, $this->page->getPage());
    }

    public function create(Request $request, Response $response, $args){
        //First, we create the basic page
        $this->page->setMetaTitle('Create a PO');
        $this->page->setMetaDescription('Create a PO.');

        //next add components, we assume the page already contains some components to only add to the content component.
        $contentTile = new componentEntity();
        $contentTile->name = 'GoHaulContentTile';
        $contentTile->props = (object)[
            "title" => 'Create New Document',
            "content" => "Please enter the details of your new document and click \"Submit\".",
            "buttons" => [
                (object)[
                    "text" => 'Document List',
                    "href" => '/documents',
                    "button" => 'btn-secondary'
                ],
            ]
        ];

        $form = new componentEntity();
        $form->name = 'Form';
        $form->addProperty('dataSrc', '/data/documents/createForm');


        $contentWrapper = new componentEntity();
        $contentWrapper->name = 'Content';
        $contentWrapper->classes = 'col-lg-10';
        $contentWrapper->addComponent($contentTile);
        $contentWrapper->addComponent($form);

        $globalWrapper = $this->page->getComponent('ThePageContent');
        $globalWrapper->addComponent($contentWrapper);
        $this->page->replaceComponent('ThePageContent', $globalWrapper);

        return System::asJson($response, $this->page->getPage());
    }

    public function update(Request $request, Response $response, $args){
        //First, we create the basic page
        $document = new documentsEntity();
        $document->load($args['ref']);

        $this->page->setMetaTitle('Update '.$document->name);
        $this->page->setMetaDescription('Update '.$document->name);

        //next add components, we assume the page already contains some components to only add to the content component.
        $contentTile = new componentEntity();
        $contentTile->name = 'GoHaulContentTile';
        $contentTile->props = (object)[
            "title" => 'Edit '.$document->name,
            "content" => "Please change the document as required and click \"Submit\".",
            "buttons" => [
                (object)[
                    "text" => 'Create New Document',
                    "href" => '/documents/create',
                    "button" => 'btn-primary'
                ],
                (object)[
                    "text" => 'Document List',
                    "href" => '/documents',
                    "button" => 'btn-secondary'
                ],
            ]
        ];

        $form = new componentEntity();
        $form->name = 'Form';
        $form->addProperty('dataSrc', '/data/documents/'.$args['ref'].'/updateForm');


        $contentWrapper = new componentEntity();
        $contentWrapper->name = 'Content';
        $contentWrapper->classes = 'col-lg-10';
        $contentWrapper->addComponent($contentTile);
        $contentWrapper->addComponent($form);

        $globalWrapper = $this->page->getComponent('ThePageContent');
        $globalWrapper->addComponent($contentWrapper);
        $this->page->replaceComponent('ThePageContent', $globalWrapper);

        return System::asJson($response, $this->page->getPage());
    }

    public function filterForm(Request $request, Response $response, $args){
        $form = new formEntity();
        $form->setId('poFilter');
        $form->setMethod('get');

        $form->addField((new inputField('search'))->setLabel('Search'), 'filter');
        return System::asJson($response, $form->getBuiltFormArray());
    }



    public function saveFile(Request $request, $response, $data){
        //get the uploaded file
        $uploadedFile = $request->getUploadedFiles();
        //save the record to DB and return the ID
        $document = new documentsEntity();
        $document->name = '';
        $document->notes = '';
        $document->file_mime_attachment = $uploadedFile['file']->getClientMediaType();
        $document->franchise = $this->currentUser->franchise;
        $document->store();

        //move it to the upload Dir, which in this case is the document id
        Utils::moveUploadedFile('documents', $uploadedFile['file']);

        $document->store();

        return System::asJson($response, ['fid' => $document->ref]);
    }

    public function getFilePathByRef($ref){
        $files = Utils::getFilesInDir($ref);
        return $files[0] ?? '';
    }

    public function dataDocumentsList($request, $response, $data){
        $params = $request->getQueryParams();

        $limit = isset($params['limit']) && !empty($params['limit']) ? $params['limit'] : 0;
        $offset = isset($params['offset']) && !empty($params['offset']) ? $params['offset'] : 0;

        $filters = $this->buildFilterConditions($params);

        $entities = (new documentsEntity())->loadMultiple($filters, ['ref'], $limit, $offset);
        $totalResults = (new documentsEntity())->totalEntities();
        $totalPages = ceil (($totalResults/$params['limit']));
        $dataArray = [];
        foreach($entities as $entity){
            $entityData = (object)$entity->getData();
            $createdUser = new userEntity();
            $createdUser->load($entityData->created_user);

            $document = new documentsEntity();
            $document->load($entityData->ref);

            $franchise = new franchiseEntity();
            $franchise->load($entityData->franchise);

            $downloadComponent = new componentEntity();
            $downloadComponent->name = 'DownloadButton';
            $downloadComponent->props = (object)[
                'ref' => $entityData->ref,
                'type' => 'documents',
            ];

            $data = (object)[
                "Ref" => $entityData->ref,
                "Name" => $document->name,
                "Format" => $document->file_mime_attachment,
                "Created" => $document->created_date,
                "#" => (object)[
                    "component" => $downloadComponent->getData(),
                ]
            ];
            $dataArray[] = $data;
        }
        $tableHeader = isset($dataArray[0]) ? array_keys((array)$dataArray[0]) : [];
        return System::asJson($response, ['rows' => $dataArray, 'totalData' => $totalResults, 'totalPages' => $totalPages, 'tableHeader' => $tableHeader]);
    }

    public function createUpdate($request, $response, $data){
        $document = new documentsEntity();
        $body = $request->getParsedBody();
        $document->load($body->document);
        if(!isset($data['ref']) ){
            $document->created_date = date('Y-m-d H:i:s');
            $document->created_user = $this->currentUser->id;
            $document->franchise = $this->currentUser->franchise;
        }

        $document->name = $body->name;

        $document->modified_date = date('Y-m-d H:i:s');
        $document->modified_user = $this->currentUser->id;

        if($document->isValid()){
            $document->store();
            return System::asJson($response, ['success' => 'true', 'redirectTo' => '/documents']);
        }

        return System::asJson($response, ['success' => 'false'], 400);
    }

    public function deleteView($request, $response, $data){
        //First, we create the basic page
        if(isset($data['ref'])){
            $params = $request->getQueryParams();
            $config = Singleton::getInstance();

            if(isset($params['type'])){
                switch($params['type']){
                    case 'documents':
                        $document = new documentsEntity();
                        break;
                    case 'attachments':
                        $document = new attachmentEntity();
                        break;
                }
            } else {
                $document = new documentsEntity();
            }

            $document->load($data['ref']);

            $this->page->setMetaTitle('Delete a Document');
            $this->page->setMetaDescription('Delete a Document.');

            //next add components, we assume the page already contains some components to only add to the content component.
            $contentTile = new componentEntity();
            $contentTile->name = 'GoHaulContentTile';
            $contentTile->props = (object)[
                "title" => 'Delete A Document',
                "content" => "Are you sure you want to delete this Document (".$document->name.")?",
                "buttons" => [
                    (object)[
                        "text" => 'Confirm Delete',
                        "href" => '/documents/'.$document->ref.'?type=attachments',
                        "button" => 'btn-danger',
                        "type" => "delete"
                    ],
                ]
            ];

            $contentWrapper = new componentEntity();
            $contentWrapper->name = 'Content';
            $contentWrapper->classes = 'col-lg-10';
            $contentWrapper->addComponent($contentTile);

            $globalWrapper = $this->page->getComponent('ThePageContent');
            $globalWrapper->addComponent($contentWrapper);
            $this->page->replaceComponent('ThePageContent', $globalWrapper);

            return System::asJson($response, $this->page->getPage());
        } else {
            return System::asJson($response, ['success' => 'false'], 404);
        }
    }

    public function delete($request, $response, $data){
        //(new documentsEntity())->delete($data['ref']);
        //check the type of document
        $params = $request->getQueryParams();
        $config = Singleton::getInstance();

        if(isset($params['type'])){
            switch($params['type']){
                case 'documents':
                    $path = '/'.$config->app->fileUploadDirectory.'/documents/';
                    $redirectTo = '/documents';
                    $document = new documentsEntity();
                    $document->load($data['ref']);
                    break;
                case 'attachments':
                    $path = '/'.$config->app->fileUploadDirectory.'/job_attachments/';
                    $document = new attachmentEntity();
                    $document->load($data['ref']);
                    $redirectTo = '/jobs/'.$document->job;
                    break;
            }
        } else {
            $document = new documentsEntity();
            $document->load($data['ref']);
        }

        $ext = Utils::mime2ext($document->file_mime_attachment);
        $withExt = strpos($document->name, '.'.$ext);
        $path .= $withExt !== FALSE ? $document->name : $document->ref;

        unlink(System::getBasePath().$path);
        $document->delete();

        return System::asJson($response, ['success' => 'true', 'redirectTo' => $redirectTo]);
    }

    public function download(Request $request, $response, $data){

        $params = $request->getQueryParams();
        $config = Singleton::getInstance();

        if(isset($params['type'])){
            switch($params['type']){
                case 'documents':
                    $path = '/'.$config->app->fileUploadDirectory.'/documents/';
                    $document = new documentsEntity();
                    break;
                case 'attachments':
                    $path = '/'.$config->app->fileUploadDirectory.'/job_attachments/';
                    $document = new attachmentEntity();
                    break;
            }
        } else {
            $document = new documentsEntity();
        }

        $document->load($data['ref']);

        $ext = Utils::mime2ext($document->file_mime_attachment);
        //minor fix to cope with jpeg/jpg
        //if we're trying to get a jpeg we might have one of 2 extensions, test for it.
        if($ext == 'jpeg'){
            switch(TRUE){
                case strpos($document->name, '.jpeg') !== FALSE:
                    //no need to change the ext
                    break;
                case strpos($document->name, '.jpg') !== FALSE:
                    $ext = 'jpg';
                    break;
            }
        }
        $withExt = strpos($document->name, '.'.$ext);

        $name = $withExt !== FALSE ? $document->name : $document->name.'.'.$ext;
        $path .= $withExt !== FALSE ? $document->name : $document->ref;

        $dataArray = [
            'path' => $path,
            'name' => $name,
            'contentType' => $document->file_mime_attachment
        ];
        return System::asJson($response, $dataArray);
    }

    protected function buildFilterConditions($params){
        $filters = [];
        foreach($params as $param => $value){
            if($param == 'limit' || $param == 'offset' || $param == 'page'){
                continue;
            }
            $filters[$param] = [$param, $value];
        }
        return $filters;
    }
}