<?php

namespace apexl\Io\modules\gohaul\controllers;

use apexl\Config\Singleton;
use apexl\Io\includes\System;
use apexl\Io\modules\page\services\Page;
use apexl\Io\modules\user\entities\companiesEntity;
use apexl\Io\modules\user\entities\franchiseEntity;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\services\currentUser;
use apexl\Io\modules\user\entities\jobEntity;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;
use Tightenco\Collect\Support\Collection;

class driverController{

    protected $page;
    /** @var userEntity */
    protected $currentUser;
    /** @var Singleton */
    protected $config;
    public function __construct(Page $page, currentUser $currentUser, Singleton $config){
        $this->page = $page;
        $this->currentUser = $currentUser::getCurrentUser();
        $this->config = $config;
    }

    public function jobList(Request $request, Response $response, $args)
    {
        $params = $request->getQueryParams();
        $weekDate = isset($params['date']) ? $params['date'] : date('Y-m-d');
        $startDate = $this->weekOfMonth(strtotime($weekDate));
        $jobEntity = new jobEntity();
        $jobs = $jobEntity->loadWeeklyJobsByDriver($startDate);
        $cacheUserDetails = [];
        foreach($jobs as $job){
            $franchise = new franchiseEntity();
            $franchise->load($job->franchise);
            $jobEntity = new jobEntity();
            $jobEntity->setData($job);
            $job->status = $jobEntity->status;
            $job->poRef = $franchise->short_name.'/'.date('ym', strtotime($job->job_date)).'/'.$job->purchase_order;
            $job->companyObject = (new companiesEntity())->load($job->company)['data'];
            if (!array_key_exists('driver_'.$job->driver, $cacheUserDetails)) {
                $cacheUserDetails['driver_'.$job->driver] = (new userEntity())->load($job->driver);
            }
            $job->driver_status = is_null($job->driver_status) ? 0 : $job->driver_status;
            $job->userInfo = $cacheUserDetails['driver_'.$job->driver]->first_name . ' ' . $cacheUserDetails['driver_'.$job->driver]->last_name;

        };
        $jobs = (new Collection($jobs))->groupBy([
            'driver',
            'job_date'
        ]);
        return System::asJson($response, $jobs);
    }

    protected function weekOfMonth($timestamp) {
        $weekNo = intval(date("W", $timestamp)) - 1;
        return $this->MondayOfWeekCalc($weekNo, date('Y', $timestamp));
    }

    protected function MondayOfWeekCalc($week, $year) {
        $timestamp = mktime( 0, 0, 0, 1, 1,  $year ) + ( $week * 7 * 24 * 60 * 60 );
        $timestamp_for_monday = $timestamp - 86400 * ( date( 'N', $timestamp ) - 1 );
        return date( 'Y-m-d', $timestamp_for_monday );
    }
}