<?php

namespace apexl\Io\modules\gohaul\controllers;

use apexl\Io\includes\System;
use apexl\Io\modules\component\entities\componentEntity;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\checkboxField;
use apexl\Io\modules\formbuilder\includes\inputField;
use apexl\Io\modules\page\services\Page;
use apexl\Io\modules\user\entities\franchiseEntity;
use apexl\Io\modules\user\entities\purchaseOrderEntity;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\services\currentUser;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class franchiseController{

    protected $page;
    /** @var userEntity */
    protected $currentUser;
    public function __construct(Page $page, currentUser $currentUser){
        $this->page = $page;
        $this->currentUser = $currentUser::getCurrentUser();
    }

    public function list(Request $request, Response $response, $args){
        //First, we create the basic page
        $this->page->setMetaTitle('View Jobs List');
        $this->page->setMetaDescription('A list of all created jobs.');

        //next add components, we assume the page already contains some components to only add to the content component.
        $contentTile = new componentEntity();
        $contentTile->name = 'GoHaulContentTile';
        $contentTile->props = (object)[
            "title" => 'Franchise Manager',
            "content" => "In here you can make changes to the franchises. Remember any changes you make will update instantly on the website.",
            "help" => 'Please select the franchise from the list below you wish to update or create a new one.',
            "buttons" => [
                (object)[
                    "text" => 'Create New Franchise',
                    "href" => '/franchisees/create',
                    "button" => 'btn-primary'
                ]
            ]
        ];

        $DataTable = new componentEntity();
        $DataTable->name = 'DataTable';
        $DataTable->addProperty('dataSrc', '/data/franchisees/list');

        $contentWrapper = new componentEntity();
        $contentWrapper->name = 'Content';
        $contentWrapper->classes = 'col-lg-10';
        $contentWrapper->addComponent($contentTile);
        $contentWrapper->addComponent($DataTable);

        $globalWrapper = $this->page->getComponent('ThePageContent');
        $globalWrapper->addComponent($contentWrapper);
        $this->page->replaceComponent('ThePageContent', $globalWrapper);

        return System::asJson($response, $this->page->getPage());
    }

    public function view(Request $request, Response $response, $args){
        if(!isset($args['ref'])){
            return System::asJson($response, ['message' => '404 not found'], 404);
        }
        $franchise = new franchiseEntity();
        $franchise->load($args['ref']);

        if(!isset($franchise->ref)){
            return System::asJson($response, ['message' => '404 not found'], 404);
        }

        //First, we create the basic page
        $this->page->setMetaTitle('Franchise '.$franchise->name);
        $this->page->setMetaDescription('Franchise '.$franchise->name);

        //next add components, we assume the page already contains some components to only add to the content component.
        $contentTile = new componentEntity();
        $contentTile->name = 'GoHaulContentTile';
        $contentTile->props = (object)[
            "title" => $franchise->name.' ('.$franchise->short_name.')',
            "content" => "",
            "buttons" => [
                (object)[
                    "text" => 'Edit This Franchise',
                    "href" => '/franchisees/'.$franchise->ref.'/edit',
                    "button" => 'btn-primary'
                ],
                (object)[
                    "text" => 'Franchise List',
                    "href" => '/franchisees',
                    "button" => 'btn-secondary'
                ],
                (object)[
                    "text" => 'Delete This Franchise',
                    "href" => '/franchisees/'.$franchise->ref.'/delete',
                    "button" => 'btn-danger'
                ]
            ]
        ];

        $user = new userEntity();
        $user->load($franchise->ref);

        $contentRows = [];
        $contentRows[] = ['Reference', $franchise->ref];
        $contentRows[] = ['Name', $franchise->name];
        $contentRows[] = ['Short Name', $franchise->short_name];
        $contentRows[] = ['Created Date',  date('d/m/Y H:i:s', $franchise->created)];
        $contentRows[] = ['Active', $franchise->active ? 'Yes' : 'No'];
        $contentRows[] = ['Created By', $user->first_name.' '.$user->last_name];

        $contentTable = new componentEntity();
        $contentTable->name = 'ContentTable';
        $contentTable->classes = 'col-md-6';
        $contentTable->rows = $contentRows;

        $contentTableSpare = new componentEntity();
        $contentTableSpare->name = 'ContentTable';
        $contentTableSpare->classes = 'col-md-6';
        $contentTableSpare->rows = [];

        $yearTable = new componentEntity();
        $yearTable->name = 'SimpleTable';
        $yearTable->title = 'Per Year';
        $yearTable->classes = 'col-sm-12';
        $yearTable->addProperty('dataSrc', '/data/pos/status/year/'.$franchise->ref);

        $monthTable = new componentEntity();
        $monthTable->name = 'SimpleTable';
        $monthTable->title = 'Per Month';
        $monthTable->classes = 'col-xl-4 col-lg-6 col-md-12';
        $monthTable->addProperty('dataSrc', '/data/pos/status/month/'.$franchise->ref);

        $weekTable = new componentEntity();
        $weekTable->name = 'SimpleTable';
        $weekTable->title = 'Per Week';
        $weekTable->classes = 'col-xl-4 col-lg-6 col-md-12';
        $weekTable->addProperty('dataSrc', '/data/pos/status/week/'.$franchise->ref);

        $dayTable = new componentEntity();
        $dayTable->name = 'SimpleTable';
        $dayTable->title = 'Per Day';
        $dayTable->classes = 'col-xl-4 col-lg-6 col-md-12';
        $dayTable->addProperty('dataSrc', '/data/pos/status/day/'.$franchise->ref);

        $rowWrapper = new componentEntity();
        $rowWrapper->name = 'RowWrapper';
        $rowWrapper->addComponent($contentTable);
        $rowWrapper->addComponent($contentTableSpare);
        $rowWrapper->addComponent($yearTable);
        $rowWrapper->addComponent($monthTable);
        $rowWrapper->addComponent($weekTable);
        $rowWrapper->addComponent($dayTable);

        $contentWrapper = new componentEntity();
        $contentWrapper->name = 'Content';
        $contentWrapper->classes = 'col-lg-10';
        $contentWrapper->addComponent($contentTile);
        $contentWrapper->addComponent($rowWrapper);

        $globalWrapper = $this->page->getComponent('ThePageContent');
        $globalWrapper->addComponent($contentWrapper);
        $this->page->replaceComponent('ThePageContent', $globalWrapper);

        return System::asJson($response, $this->page->getPage());
    }

    public function create(Request $request, Response $response, $args){
        //First, we create the basic page
        $this->page->setMetaTitle('Create a PO');
        $this->page->setMetaDescription('Create a PO.');

        //next add components, we assume the page already contains some components to only add to the content component.
        $contentTile = new componentEntity();
        $contentTile->name = 'GoHaulContentTile';
        $contentTile->props = (object)[
            "title" => 'Create New Franchise',
            "content" => "Please enter the details of your new franchise and click \"Submit\".",
            "buttons" => [
                (object)[
                    "text" => 'Franchise List',
                    "href" => '/franchisees',
                    "button" => 'btn-secondary'
                ],
            ]
        ];

        $form = new componentEntity();
        $form->name = 'Form';
        $form->addProperty('dataSrc', '/data/franchisees/createForm');


        $contentWrapper = new componentEntity();
        $contentWrapper->name = 'Content';
        $contentWrapper->classes = 'col-lg-10';
        $contentWrapper->addComponent($contentTile);
        $contentWrapper->addComponent($form);

        $globalWrapper = $this->page->getComponent('ThePageContent');
        $globalWrapper->addComponent($contentWrapper);
        $this->page->replaceComponent('ThePageContent', $globalWrapper);

        return System::asJson($response, $this->page->getPage());
    }

    public function update(Request $request, Response $response, $args){
        //First, we create the basic page
        $po = new purchaseOrderEntity();
        $po->load($args['ref']);

        $franchise = new franchiseEntity();
        $franchise->load($po->franchise);

        $this->page->setMetaTitle('Create a PO');
        $this->page->setMetaDescription('Create a PO.');

        //next add components, we assume the page already contains some components to only add to the content component.
        $contentTile = new componentEntity();
        $contentTile->name = 'GoHaulContentTile';
        $contentTile->props = (object)[
            "title" => 'Edit '.$franchise->name.' ('.$franchise->short_name.')',
            "content" => "Please change the franchise as required and click \"Submit\".",
            "buttons" => [
                (object)[
                    "text" => 'Create New Franchise',
                    "href" => '/franchisees/create',
                    "button" => 'btn-primary'
                ],
                (object)[
                    "text" => 'Franchise List',
                    "href" => '/franchisees',
                    "button" => 'btn-secondary'
                ],
            ]
        ];

        $form = new componentEntity();
        $form->name = 'Form';
        $form->addProperty('dataSrc', '/data/franchisees/'.$args['ref'].'/updateForm');

        $contentWrapper = new componentEntity();
        $contentWrapper->name = 'Content';
        $contentWrapper->classes = 'col-lg-10';
        $contentWrapper->addComponent($contentTile);
        $contentWrapper->addComponent($form);

        $globalWrapper = $this->page->getComponent('ThePageContent');
        $globalWrapper->addComponent($contentWrapper);
        $this->page->replaceComponent('ThePageContent', $globalWrapper);

        return System::asJson($response, $this->page->getPage());
    }

    public function manageForm(Request $request, Response $response, $args)
    {
        $franchise = FALSE;
        if (isset($args['ref'])) {
            $franchise = new franchiseEntity();
            $franchise->load($args['ref']);
        }

        $form = new formEntity();
        $form->setId('managefranchise');
        $form->setMethod('post');
        $form->setActionUrl('franchisees');
        if($franchise){
            $form->setActionUrl('franchisees/'.$args['ref']);
        }

        $name = (new inputField('name'))->setLabel('Franchise Name')->isRequired();
        if($franchise){
            $name->setValue($franchise->name);
        }
        $form->addField($name, 'details');

        $shortName = (new inputField('short_name'))->setLabel('Short Name')->isRequired();
        if($franchise){
            $shortName->setValue($franchise->short_name);
        }
        $form->addField($shortName, 'details');

        $active = (new checkboxField('active'))->setLabel('Active?');
        if($franchise && $franchise->active){
            $active->setValue($franchise->active);
        }
        $form->addField($active, 'details');

        $clientId = (new inputField('sage_client_id'))->setLabel('Client ID')->isRequired();
        if($franchise){
            $clientId->setValue($franchise->sage_client_id);
        }
        $form->addField($clientId, 'sage');

        $clientSecret = (new inputField('sage_client_secret'))->setLabel('Client Secret')->isRequired();
        if($franchise){
            $clientSecret->setValue($franchise->sage_client_secret);
        }
        $form->addField($clientSecret, 'sage');

        $signingSecret = (new inputField('sage_signing_secret'))->setLabel('Signing Secret')->isRequired();
        if($franchise){
            $signingSecret->setValue($franchise->sage_signing_secret);
        }
        $form->addField($signingSecret, 'sage');

        $subscriptionID = (new inputField('sage_subscription_id'))->setLabel('Subscription ID')->isRequired();
        if($franchise){
            $subscriptionID->setValue($franchise->sage_subscription_id);
        }
        $form->addField($subscriptionID, 'sage');

        $nominal = (new inputField('sage_nominalCode'))->setLabel('Sales Account Nominal Code')->isRequired();
        if($franchise){
            $nominal->setValue($franchise->sage_nominalCode);
        }
        $form->addField($nominal, 'sage');

        $ledgerID = (new inputField('sage_ledger_id'))->setLabel('Invoice Account ID');
        if($franchise){
            $ledgerID->setValue($franchise->sage_ledger_id);
        }
        $form->addField($ledgerID, 'sage');

        return System::asJson($response, $form->getBuiltFormArray());
    }

    public function dataFranchiseList($request, $response, $data){
        $params = $request->getQueryParams();

        $limit = isset($params['limit']) && !empty($params['limit']) ? $params['limit'] : 0;
        $offset = isset($params['offset']) && !empty($params['offset']) ? $params['offset'] : 0;

        $entities = (new franchiseEntity())->loadMultiple([], ['ref'], $limit, $offset);
        $totalResults = (new franchiseEntity())->totalEntities();
        $totalPages = ceil (($totalResults/$params['limit']));
        $dataArray = [];
        foreach($entities as $entity){
            $entityData = (object)$entity->getData();
            $createdUser = new userEntity();
            $createdUser->load($entityData->created_user);

            $data = (object)[
                "Ref" => $entityData->ref,
                "Name" => $entityData->name,
                "Short Name" => $entityData->short_name,
                "Active" => $entityData->active,
                "Created By" => $createdUser->first_name.' '.$createdUser->last_name,
                "Created Date" => date('d/m/Y', $entityData->created)
            ];
            $dataArray[] = $data;
        }
        $tableHeader = isset($dataArray[0]) ? array_keys((array)$dataArray[0]) : [];
        return System::asJson($response, ['rows' => $dataArray, 'totalData' => $totalResults, 'totalPages' => $totalPages, 'tableHeader' => $tableHeader]);
    }

    public function createUpdate($request, $response, $data){
        $franchise = new franchiseEntity();
        if(isset($data['ref'])){
            $franchise->load($data['ref']);
        } else {
            $franchise->created = time();
            $franchise->created_user = $this->currentUser->id;
        }
        //standard Details
        $body = $request->getParsedBody();
        $franchise->name = $body->name;
        $franchise->short_name = $body->short_name;
        $franchise->active = $body->active;

        //sage
        $franchise->sage_client_id = $body->sage_client_id;
        $franchise->sage_client_secret = $body->sage_client_secret;
        $franchise->sage_signing_secret = $body->sage_signing_secret;
        $franchise->sage_subscription_id = $body->sage_subscription_id;
        $franchise->sage_ledger_id = $body->sage_ledger_id;
        $franchise->sage_nominalCode = $body->sage_nominalCode;

        if($franchise->isValid()){
            $franchise->store();
            return System::asJson($response, ['success' => 'true', 'redirectTo' => '/franchisees']);
        } else {
            return System::asJson($response, ['success' => 'false'], 400);
        }
    }

    public function deleteView($request, $response, $data){
        //First, we create the basic page
        $franchise = new franchiseEntity();
        if(isset($data['ref'])){
            $franchise->load($data['ref']);

            $this->page->setMetaTitle('Delete a Franchise');
            $this->page->setMetaDescription('Delete a Franchise.');

            //next add components, we assume the page already contains some components to only add to the content component.
            $contentTile = new componentEntity();
            $contentTile->name = 'GoHaulContentTile';
            $contentTile->props = (object)[
                "title" => 'Delete A Franchise',
                "content" => "Are you sure you want to delete this Franchise (".$franchise->name.")?",
                "buttons" => [
                    (object)[
                        "text" => 'Confirm Delete',
                        "href" => '/franchisees/'.$franchise->ref,
                        "button" => 'btn-danger',
                        "type" => "delete"
                    ],
                ]
            ];

            $contentWrapper = new componentEntity();
            $contentWrapper->name = 'Content';
            $contentWrapper->classes = 'col-lg-10';
            $contentWrapper->addComponent($contentTile);

            $globalWrapper = $this->page->getComponent('ThePageContent');
            $globalWrapper->addComponent($contentWrapper);
            $this->page->replaceComponent('ThePageContent', $globalWrapper);

            return System::asJson($response, $this->page->getPage());
        } else {
            return System::asJson($response, ['success' => 'false'], 404);
        }
    }

    public function delete($request, $response, $data){
        (new franchiseEntity())->delete($data['ref']);
        return System::asJson($response, ['success' => 'true', 'redirectTo' => '/franchisees']);
    }
}