<?php

namespace apexl\Io\modules\gohaul\controllers;

use apexl\Io\includes\System;
use apexl\Io\modules\page\services\Page;
use apexl\Io\modules\component\entities\componentEntity;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class homeController{
    protected $page;

    public function __construct(Page $page){
        $this->page = $page;
    }

    public function dashboard(Request $request, Response $response, $args)
    {

        $DataTable = new componentEntity();
        $DataTable->name = 'DriverDataTable';
        $DataTable->basePath = '/jobs';
        $DataTable->addProperty('dataSrc', '/api/driver/jobs?limit=20&offset=0');

        $contentTile = new componentEntity();
        $contentTile->name = 'GoHaulContentTile';
        $contentTile->props = (object)[
            "title" => 'Ready to invoice',
            "content" => "This is all jobs that are ready to invoice.",
        ];

        $invoiceTable = new componentEntity();
        $invoiceTable->name = 'SimpleTable';
        $invoiceTable->addProperty('dataSrc', '/data/jobs/simpleList?status=Ready to be invoiced');

        $contentWrapper = new componentEntity();
        $contentWrapper->name = 'Content';
        $contentWrapper->classes = 'col-lg-10';
        $contentWrapper->addComponent($DataTable);
        $contentWrapper->addComponent($contentTile);
        $contentWrapper->addComponent($invoiceTable);

        $globalWrapper = $this->page->getComponent('ThePageContent');
        $globalWrapper->addComponent($contentWrapper);
        $this->page->replaceComponent('ThePageContent', $globalWrapper);

        return System::asJson($response, $this->page->getPage());
    }
}