<?php

namespace apexl\Io\modules\gohaul\controllers;

use apexl\Io\includes\System;
use apexl\Io\modules\component\entities\componentEntity;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\datePickerField;
use apexl\Io\modules\formbuilder\includes\inputField;
use apexl\Io\modules\formbuilder\includes\selectField;
use apexl\Io\modules\formbuilder\includes\textareaField;
use apexl\Io\modules\page\services\Page;
use apexl\Io\modules\user\entities\contactEntity;
use apexl\Io\modules\user\entities\franchiseEntity;
use apexl\Io\modules\user\entities\jobEntity;
use apexl\Io\modules\user\entities\purchaseOrderEntity;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\services\currentUser;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class posController{

    protected $page;
    /** @var userEntity */
    protected $currentUser;
    public function __construct(Page $page, currentUser $currentUser){
        $this->page = $page;
        $this->currentUser = $currentUser::getCurrentUser();
    }

    public function list(Request $request, Response $response, $args){
        //First, we create the basic page
        $this->page->setMetaTitle('View Jobs List');
        $this->page->setMetaDescription('A list of all created jobs.');

        //next add components, we assume the page already contains some components to only add to the content component.
        $contentTile = new componentEntity();
        $contentTile->name = 'GoHaulContentTile';
        $contentTile->props = (object)[
            "title" => 'Purchase Order Manager',
            "content" => "In here you can make changes to the purchase orders. Remember any changes you make will update instantly on the website.",
            "help" => 'Please select the purchase order from the list below you wish to update or create a new one.',
            "buttons" => [
                (object)[
                    "text" => 'Create New Purchase Order',
                    "href" => '/pos/create',
                    "button" => 'btn-primary'
                ],
                (object)[
                    "text" => 'Purchase Order Stats',
                    "href" => '/pos/status',
                    "button" => 'btn-secondary'
                ]
            ]
        ];

        $filterForm = new componentEntity();
        $filterForm->name = 'FilterForm';
        $filterForm->addProperty('dataSrc', '/data/pos/filterForm');


        $DataTable = new componentEntity();
        $DataTable->name = 'DataTable';
        $DataTable->addProperty('dataSrc', '/data/pos/list');


        $contentWrapper = new componentEntity();
        $contentWrapper->name = 'Content';
        $contentWrapper->classes = 'col-lg-10';
        $contentWrapper->addComponent($contentTile);
        $contentWrapper->addComponent($filterForm);
        $contentWrapper->addComponent($DataTable);

        $globalWrapper = $this->page->getComponent('ThePageContent');
        $globalWrapper->addComponent($contentWrapper);
        $this->page->replaceComponent('ThePageContent', $globalWrapper);

        return System::asJson($response, $this->page->getPage());
    }

    public function status(Request $request, Response $response, $args){
        $this->page->setMetaTitle('Purchase Order Status');
        $this->page->setMetaDescription('Purchase Order Status');

        //next add components, we assume the page already contains some components to only add to the content component.
        $contentTile = new componentEntity();
        $contentTile->name = 'GoHaulContentTile';
        $contentTile->props = (object)[
            "title" => 'Purchase Order Stats',
            "content" => "",
            "buttons" => [
                (object)[
                    "text" => 'Create New Purchase Order',
                    "href" => '/pos/create',
                    "button" => 'btn-primary'
                ],
                (object)[
                    "text" => 'PO List',
                    "href" => '/pos',
                    "button" => 'btn-secondary'
                ],
            ]
        ];

        $yearTable = new componentEntity();
        $yearTable->name = 'SimpleTable';
        $yearTable->title = 'Per Year';
        $yearTable->classes = 'col-sm-12';
        $yearTable->addProperty('dataSrc', '/data/pos/status/year/'.$this->currentUser->franchise);

        $monthTable = new componentEntity();
        $monthTable->name = 'SimpleTable';
        $monthTable->title = 'Per Month';
        $monthTable->classes = 'col-md-6 col-lg-4';
        $monthTable->addProperty('dataSrc', '/data/pos/status/month/'.$this->currentUser->franchise);

        $weekTable = new componentEntity();
        $weekTable->name = 'SimpleTable';
        $weekTable->title = 'Per Week';
        $weekTable->classes = 'col-md-6 col-lg-4';
        $weekTable->addProperty('dataSrc', '/data/pos/status/week/'.$this->currentUser->franchise);

        $dayTable = new componentEntity();
        $dayTable->name = 'SimpleTable';
        $dayTable->title = 'Per Day';
        $dayTable->classes = 'col-md-6 col-lg-4';
        $dayTable->addProperty('dataSrc', '/data/pos/status/day/'.$this->currentUser->franchise);

        $rowWrapper = new componentEntity();
        $rowWrapper->name = 'RowWrapper';
        $rowWrapper->addComponent($yearTable);
        $rowWrapper->addComponent($monthTable);
        $rowWrapper->addComponent($weekTable);
        $rowWrapper->addComponent($dayTable);

        $contentWrapper = new componentEntity();
        $contentWrapper->name = 'Content';
        $contentWrapper->classes = 'col-lg-10';
        $contentWrapper->addComponent($contentTile);
        $contentWrapper->addComponent($rowWrapper);

        $globalWrapper = $this->page->getComponent('ThePageContent');
        $globalWrapper->addComponent($contentWrapper);
        $this->page->replaceComponent('ThePageContent', $globalWrapper);

        return System::asJson($response, $this->page->getPage());
    }

    public function statusData(Request $request, Response $response, $args){
        $conditions = [];
        if(isset($args['franchise'])){
            $conditions = ['franchise' => ['purchase_orders.franchise', $args['franchise']]];
        }
        $pos = (new purchaseOrderEntity())->loadMultiple($conditions, ['created_date']);

        $poRowData = [];
        foreach($pos as $po) {
            $poData = (object)$po->getData();
            $time = strtotime($poData->created_date);
            switch($args['band']) {
                case 'year':
                    $key = date('Y', $time);
                    break;
                case 'month':
                    $key = date('M Y', $time);
                    break;
                case 'week':
                    $key = date('Y W', $time);
                    break;
                case 'day':
                    $key = date('d/m/Y', $time);
                    break;
            }
            $poRowData[$key]['their_price'] = isset($poRowData[$key]['their_price']) ? ($poRowData[$key]['their_price']) + $poData->their_price : $poData->their_price;
            $poRowData[$key]['our_price'] = isset($poRowData[$key]['our_price']) ? ($poRowData[$key]['our_price']) + $poData->our_price : $poData->our_price;
        }



        $dataArray = [];
        foreach($poRowData as $key => $row){

            $data = (object)[
                ucfirst($args['band']) => $key,
                "Their Price" => '£'.number_format($row['their_price'], 2),
                "Our Price" => '£'.number_format($row['our_price'], 2),
                "Margin" => '£'.number_format(($row['our_price'] - $row['their_price']), 2),
            ];
            $dataArray[] = $data;
        }
        $tableHeader = isset($dataArray[0]) ? array_keys((array)$dataArray[0]) : [];
        return System::asJson($response, ['rows' => $dataArray, 'tableHeader' => $tableHeader]);
    }

    public function view(Request $request, Response $response, $args){
        if(!isset($args['ref'])){
            return System::asJson($response, ['message' => '404 not found'], 404);
        }
        $po = new purchaseOrderEntity();
        $po->load($args['ref']);

        if(!isset($po->ref)){
            return System::asJson($response, ['message' => '404 not found'], 404);
        }

        $franchise = new franchiseEntity();
        $franchise->load($po->franchise);

        //First, we create the basic page
        $this->page->setMetaTitle('Purchase Order '.$franchise->short_name."/".date('ym').'/'.$po->ref);
        $this->page->setMetaDescription('Purchase Order '.$franchise->short_name."/".date('ym').'/'.$po->ref);

        //next add components, we assume the page already contains some components to only add to the content component.
        $contentTile = new componentEntity();
        $contentTile->name = 'GoHaulContentTile';
        $contentTile->props = (object)[
            "title" => 'Purchase Order '.$franchise->short_name."/".date('ym', strtotime($po->created_date)).'/'.$po->ref,
            "content" => "",
            "buttons" => [
                (object)[
                    "text" => 'Edit This PO',
                    "href" => '/pos/'.$po->ref.'/edit',
                    "button" => 'btn-primary'
                ],
                (object)[
                    "text" => 'Clone This PO',
                    "href" => '/pos/'.$po->ref.'/clone',
                    "button" => 'btn-secondary'
                ],
                (object)[
                    "text" => 'PO List',
                    "href" => '/pos',
                    "button" => 'btn-secondary'
                ],
                (object)[
                    "text" => 'Delete This PO',
                    "href" => '/pos/'.$po->ref.'/delete',
                    "button" => 'btn-danger'
                ]
            ]
        ];

        $contentRows = [];
        $contentRows[] = ['Collection', $po->collection];
        $contentRows[] = ['Delivery', $po->delivery];
        $contentRows[] = ['Haulier', $po->haulier];
        $contentRows[] = ['Their Price', $po->their_price];
        $contentRows[] = ['Our Price', $po->our_price];

        $contentDetailsTable = new componentEntity();
        $contentDetailsTable->name = 'ContentTable';
        $contentDetailsTable->classes = 'col-md-3';
        $contentDetailsTable->title = 'Details';
        $contentDetailsTable->rows = $contentRows;

        $contentRows = [];

        if(!empty($po->created_user)) {
            $createdBy = new userEntity();
            $createdBy->load($po->created_user);
            $contentRows[] = ['Created By', $createdBy->first_name . ' ' . $createdBy->last_name];
            $contentRows[] = ['Created Date', $po->created_date];
        }
        if(!empty($po->modified_user)) {
            $modifiedBy = new userEntity();
            $modifiedBy->load($po->modified_user);
            $contentRows[] = ['Modified By', $modifiedBy->first_name . ' ' . $modifiedBy->last_name];
            $contentRows[] = ['Modified Date', $po->modified_date];
        }

        $contentHistoryTable = new componentEntity();
        $contentHistoryTable->name = 'ContentTable';
        $contentHistoryTable->classes = 'col-md-3';
        $contentHistoryTable->title = 'History';
        $contentHistoryTable->rows = $contentRows;

        $notesTile = new componentEntity();
        $notesTile->name = 'GoHaulContentTile';
        $notesTile->classes = 'col-md-3';
        $notesTile->props = (object)[
            "title" => 'Notes',
            "content" => $po->notes,
        ];

        $rowWrapper = new componentEntity();
        $rowWrapper->name = 'RowWrapper';
        $rowWrapper->addComponent($contentDetailsTable);
        $rowWrapper->addComponent($contentHistoryTable);
        $rowWrapper->addComponent($notesTile);

        $contentWrapper = new componentEntity();
        $contentWrapper->name = 'Content';
        $contentWrapper->classes = 'col-lg-10';
        $contentWrapper->addComponent($contentTile);
        $contentWrapper->addComponent($rowWrapper);

        $globalWrapper = $this->page->getComponent('ThePageContent');
        $globalWrapper->addComponent($contentWrapper);
        $this->page->replaceComponent('ThePageContent', $globalWrapper);

        return System::asJson($response, $this->page->getPage());
    }

    public function create(Request $request, Response $response, $args){
        //First, we create the basic page
        $this->page->setMetaTitle('Create a PO');
        $this->page->setMetaDescription('Create a PO.');

        //next add components, we assume the page already contains some components to only add to the content component.
        $contentTile = new componentEntity();
        $contentTile->name = 'GoHaulContentTile';
        $contentTile->props = (object)[
            "title" => 'Create New Purchase Order',
            "content" => "Please enter the details of your new purchase order and click \"Submit\".",
            "buttons" => [
                (object)[
                    "text" => 'Pos List',
                    "href" => '/pos',
                    "button" => 'btn-secondary'
                ],
            ]
        ];

        $form = new componentEntity();
        $form->name = 'Form';
        $form->addProperty('dataSrc', '/data/pos/createForm');


        $contentWrapper = new componentEntity();
        $contentWrapper->name = 'Content';
        $contentWrapper->classes = 'col-lg-10';
        $contentWrapper->addComponent($contentTile);
        $contentWrapper->addComponent($form);

        $globalWrapper = $this->page->getComponent('ThePageContent');
        $globalWrapper->addComponent($contentWrapper);
        $this->page->replaceComponent('ThePageContent', $globalWrapper);

        return System::asJson($response, $this->page->getPage());
    }

    public function update(Request $request, Response $response, $args){
        //First, we create the basic page
        $po = new purchaseOrderEntity();
        $po->load($args['ref']);

        $franchise = new franchiseEntity();
        $franchise->load($po->franchise);

        $this->page->setMetaTitle('Create a PO');
        $this->page->setMetaDescription('Create a PO.');

        //next add components, we assume the page already contains some components to only add to the content component.
        $contentTile = new componentEntity();
        $contentTile->name = 'GoHaulContentTile';
        $contentTile->props = (object)[
            "title" => 'Edit '.$franchise->short_name."/".date('ym').'/'.$po->ref,
            "content" => "Please change the purchase order as required and click \"Submit\".",
            "buttons" => [
                (object)[
                    "text" => 'Create New PO',
                    "href" => '/pos/create',
                    "button" => 'btn-primary'
                ],
                (object)[
                    "text" => 'Pos List',
                    "href" => '/pos',
                    "button" => 'btn-secondary'
                ],
            ]
        ];

        $form = new componentEntity();
        $form->name = 'Form';
        $form->addProperty('dataSrc', '/data/pos/'.$args['ref'].'/updateForm');


        $contentWrapper = new componentEntity();
        $contentWrapper->name = 'Content';
        $contentWrapper->classes = 'col-lg-10';
        $contentWrapper->addComponent($contentTile);
        $contentWrapper->addComponent($form);

        $globalWrapper = $this->page->getComponent('ThePageContent');
        $globalWrapper->addComponent($contentWrapper);
        $this->page->replaceComponent('ThePageContent', $globalWrapper);

        return System::asJson($response, $this->page->getPage());
    }

    public function clone(Request $request, Response $response, $args){
        //First, we create the basic page
        $po = new purchaseOrderEntity();
        $po->load($args['ref']);

        $franchise = new franchiseEntity();
        $franchise->load($po->franchise);

        $this->page->setMetaTitle('Clone a PO');
        $this->page->setMetaDescription('Clone a PO.');

        //next add components, we assume the page already contains some components to only add to the content component.
        $contentTile = new componentEntity();
        $contentTile->name = 'GoHaulContentTile';
        $contentTile->props = (object)[
            "title" => 'Clone '.$franchise->short_name."/".date('ym').'/'.$po->ref,
            "content" => "Please change the purchase order as required and click \"Submit\".",
            "buttons" => [
                (object)[
                    "text" => 'Create New PO',
                    "href" => '/pos/create',
                    "button" => 'btn-primary'
                ],
                (object)[
                    "text" => 'Pos List',
                    "href" => '/pos',
                    "button" => 'btn-secondary'
                ],
            ]
        ];

        $form = new componentEntity();
        $form->name = 'Form';
        $form->addProperty('dataSrc', '/data/pos/'.$args['ref'].'/updateForm?clone=true');


        $contentWrapper = new componentEntity();
        $contentWrapper->name = 'Content';
        $contentWrapper->classes = 'col-lg-10';
        $contentWrapper->addComponent($contentTile);
        $contentWrapper->addComponent($form);

        $globalWrapper = $this->page->getComponent('ThePageContent');
        $globalWrapper->addComponent($contentWrapper);
        $this->page->replaceComponent('ThePageContent', $globalWrapper);

        return System::asJson($response, $this->page->getPage());
    }

    public function filterForm(Request $request, Response $response, $args){
        $form = new formEntity();
        $form->setId('poFilter');
        $form->setMethod('get');

        $person = (new userEntity())->loadMultiple([], ["first_name"]);
        $personField = (new selectField('person'))->buildOptionsFromEntities($person, 'id', 'first_name')->setLabel('Person');
        $form->addField($personField, 'filter');

        $form->addField((new datePickerField('from_date'))->setLabel('From Date'), 'filter');
        $form->addField((new datePickerField('to_date'))->setLabel('To Date'), 'filter');

        $statusList = [
            "" => 'All',
            "Ready to be invoiced" => "Ready to be invoiced",
            "Invoiced" => "Invoiced",
        ];
        $status = (new selectField('status'))->addOptions($statusList)->setLabel('Status');
        //Details Fieldset
        $form->addField($status, 'filter');

        $form->addField((new inputField('search'))->setLabel('Search'), 'filter');
        return System::asJson($response, $form->getBuiltFormArray());
    }

    public function manageForm(Request $request, Response $response, $args)
    {
        $po = FALSE;
        if (isset($args['ref'])) {
            $po = new purchaseOrderEntity();
            $po->load($args['ref']);
        }

        $form = new formEntity();
        $form->setId('managePos');
        $form->setMethod('post');
        $form->setActionUrl('pos');
        if($po){
            $params = $request->getQueryParams();
            if(!isset($params['clone'])){
                $form->setActionUrl('pos/'.$args['ref']);
            }
        }

        $collection = (new inputField('collection'))->setLabel('Collection')->isRequired();
        if($po){
            $collection->setValue($po->collection);
        }
        $form->addField($collection, 'details');

        $delivery = (new inputField('delivery'))->setLabel('Delivery');
        if($po){
            $delivery->setValue($po->delivery);
        }
        $form->addField($delivery, 'details');

        $haulier = (new inputField('haulier'))->setLabel('Haulier');
        if($po){
            $haulier->setValue($po->haulier);
        }
        $form->addField($haulier, 'details');

        $their_price = (new inputField('their_price'))->setLabel('Their Price');
        if($po){
            $their_price->setValue($po->their_price);
        }
        $form->addField($their_price, 'details');

        $our_price = (new inputField('our_price'))->setLabel('Our Price');
        if($po){
            $our_price->setValue($po->our_price);
        }
        $form->addField($our_price, 'details');

        $vehicle_registration = (new inputField('vehicle_registration'))->setLabel('Vehicle Registration');
        if($po){
            $vehicle_registration->setValue($po->vehicle_registration);
        }
        $form->addField($vehicle_registration, 'details');

        $notes = (new textareaField('notes'))->setLabel('Notes');
        if($po){
            $notes->setValue($po->notes);
        }
        $form->addField($notes, 'details');


        return System::asJson($response, $form->getBuiltFormArray());
    }

    public function dataPosList($request, $response, $data){
        $params = $request->getQueryParams();

        $limit = isset($params['limit']) && !empty($params['limit']) ? $params['limit'] : 0;
        $offset = isset($params['offset']) && !empty($params['offset']) ? $params['offset'] : 0;

        $filters = $this->buildFilterConditions($params);

        $entities = (new purchaseOrderEntity())->loadMultiple($filters, ['purchase_orders.ref'], $limit, $offset);
        $totalResults = (new purchaseOrderEntity())->totalEntities();
        $totalPages = ceil (($totalResults/$params['limit']));
        $dataArray = [];
        foreach($entities as $entity){
            $entityData = (object)$entity->getData();
            $createdUser = new userEntity();
            $createdUser->load($entityData->created_user);

            $franchise = new franchiseEntity();
            $franchise->load($entityData->franchise);

            $job = new jobEntity();
            $job->loadByPo($entityData->ref);
            $data = (object)[
                "Ref" => $entityData->ref,
                "Job Number" => $franchise->short_name . "/" . date('ym', strtotime($entityData->created_date)) . '/' . $entityData->ref, //@todo change GHL for franchise data.
                "Collection" => $entityData->collection,
                "Delivery" => $entityData->delivery,
                "Haulier" => $entityData->haulier,
                "Vehicle Registration" => $entityData->vehicle_registration,
                "Their Price" => $entityData->their_price,
                "Our Price" => $entityData->our_price,
                "Invoiced" => "£" . $job->invoiced_amount,
                "Paid" => "£" . $job->amount_paid,
                "Person" => $createdUser->first_name . ' ' . $createdUser->last_name,
                "Date" => date('d/m/Y', strtotime($entityData->created_date))
            ];
            $dataArray[] = $data;
        }
        $tableHeader = isset($dataArray[0]) ? array_keys((array)$dataArray[0]) : [];
        return System::asJson($response, ['rows' => $dataArray, 'totalData' => $totalResults, 'totalPages' => $totalPages, 'tableHeader' => $tableHeader]);
    }

    public function createUpdate($request, $response, $data){
        $po = new purchaseOrderEntity();
        $body = $request->getParsedBody();
        if(isset($data['ref'])){
            $po->load($data['ref']);
        } else {
            $po->created_date = date('Y-m-d H:i:s');
            $po->created_user = $this->currentUser->id;
            $po->franchise = $this->currentUser->franchise;
        }

        $po->collection = $body->collection;
        $po->delivery = $body->delivery;
        $po->haulier = $body->haulier;
        $po->their_price = $body->their_price;
        $po->our_price = $body->our_price;
        $po->notes = $body->notes;
        $po->vehicle_registration = $body->vehicle_registration;

        $po->modified_date = date('Y-m-d H:i:s');
        $po->modified_user = $this->currentUser->id;

        if($po->isValid()){
            $po->store();
            return System::asJson($response, ['success' => 'true', 'redirectTo' => '/pos']);
        }

        return System::asJson($response, ['success' => 'false'], 400);
    }

    public function deleteView($request, $response, $data){
        //First, we create the basic page
        $po = new purchaseOrderEntity();
        if(isset($data['ref'])){
            $po->load($data['ref']);

            $this->page->setMetaTitle('Delete a Po');
            $this->page->setMetaDescription('Delete a Po.');

            //next add components, we assume the page already contains some components to only add to the content component.
            $contentTile = new componentEntity();
            $contentTile->name = 'GoHaulContentTile';
            $contentTile->props = (object)[
                "title" => 'Delete A Purchase Order',
                "content" => "Are you sure you want to delete this Purchase order (".$po->ref.")?",
                "buttons" => [
                    (object)[
                        "text" => 'Confirm Delete',
                        "href" => '/pos/'.$po->ref,
                        "button" => 'btn-danger',
                        "type" => "delete"
                    ],
                ]
            ];

            $contentWrapper = new componentEntity();
            $contentWrapper->name = 'Content';
            $contentWrapper->classes = 'col-lg-10';
            $contentWrapper->addComponent($contentTile);

            $globalWrapper = $this->page->getComponent('ThePageContent');
            $globalWrapper->addComponent($contentWrapper);
            $this->page->replaceComponent('ThePageContent', $globalWrapper);

            return System::asJson($response, $this->page->getPage());
        } else {
            return System::asJson($response, ['success' => 'false'], 404);
        }
    }

    public function delete($request, $response, $data){
        (new purchaseOrderEntity())->delete($data['ref']);
        return System::asJson($response, ['success' => 'true', 'redirectTo' => '/pos']);
    }

    protected function buildFilterConditions($params){
        $filters = [];
        foreach($params as $param => $value){
            if($param == 'limit' || $param == 'offset' || $param == 'page' || empty($value)){
                continue;
            }
            switch($param){
                case 'search':
                    $filters['ref'] = ['purchase_orders.ref', '%'.$value.'%', 'like', 'AND ('];
                    $filters['collection'] = ['purchase_orders.collection', '%'.$value.'%', 'like', 'OR'];
                    $filters['delivery'] = ['purchase_orders.delivery', '%'.$value.'%', 'like', 'OR'];
                    $filters['vehicle_registration'] = ['purchase_orders.vehicle_registration', '%'.$value.'%', 'like', 'OR'];
                    $filters['haulier'] = ['purchase_orders.haulier', '%'.$value.'%)', 'like', 'OR', ')'];
                    break;
                case 'to_date':
                    $filters['to_date'] = ['purchase_orders.created_date', $value, '<=', 'AND'];
                    break;
                case 'from_date':
                    $filters['from_date'] = ['purchase_orders.created_date', $value, '>=', 'AND'];
                    break;
                case 'person':
                    $filters['created_user'] = ['purchase_orders.created_user', $value, '=', 'AND'];
                    break;
                case 'status':
                    $filters = $filters + $this->statusQueries($value);
                    break;
            }
        }
        return $filters;
    }

    /**
     * "Pending" => "Pending",
     * "Ongoing" => "Ongoing",
     * "Overdue" => "Overdue",
     * "Complete" => "Complete",
     * "Ready to be invoiced" => "Ready to be invoiced",
     * "Invoiced" => "Invoiced"
     *
     * @param $status
     * @return array|string
     */
    protected function statusQueries($status){
        $query = [];
        switch($status){
            case 'Invoiced': //!is_null($this->invoiced_amount) && (is_null($this->amount_paid) || $this->amount_paid < $this->invoiced_amount):
                $query['jobs_ref'] = ['jobs.ref', 'NULL', 'IS NOT NULL'];
                return $query;
                break;
            case 'Ready to be invoiced':
                $query['completed_date'] = ['jobs.ref', 'NULL', 'IS NULL'];
                return $query;
                break;
        }
        return 'Unknown';
    }
}