<?php

namespace apexl\Io\modules\gohaul\controllers;

use apexl\Io\includes\System;
use apexl\Io\modules\component\entities\componentEntity;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\checkboxField;
use apexl\Io\modules\formbuilder\includes\inputField;
use apexl\Io\modules\page\services\Page;
use apexl\Io\modules\user\entities\franchiseEntity;
use apexl\Io\modules\user\entities\roleEntity;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\services\currentUser;
use apexl\Io\modules\user\services\Permissions;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class rolesController{

    protected $page;
    /** @var userEntity */
    protected $currentUser;

    /** @var Permissions */
    protected $permissions;

    public function __construct(Page $page, currentUser $currentUser, Permissions $permissions){
        $this->page = $page;
        $this->currentUser = $currentUser::getCurrentUser();
        $this->permissions = $permissions;
    }

    protected function buildFilterConditions($params){
        $filters = [];
        foreach($params as $param => $value){
            if($param == 'limit' || $param == 'offset' || $param == 'page'){
                continue;
            }
            $filters[$param] = [$param, $value];
        }
        return $filters;
    }
}