<?php

namespace apexl\Io\modules\gohaul\controllers;

use apexl\Io\includes\System;
use apexl\Io\modules\component\entities\componentEntity;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\inputField;
use apexl\Io\modules\page\services\Page;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\entities\vehicleTypeEntity;
use apexl\Io\modules\user\services\currentUser;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class typesController{

    protected $page;
    /** @var userEntity */
    protected $currentUser;

    protected $permissions;

    public function __construct(Page $page, currentUser $currentUser){
        $this->page = $page;
        $this->currentUser = $currentUser::getCurrentUser();
    }

    public function list(Request $request, Response $response, $args){
        //First, we create the basic page
        $this->page->setMetaTitle('View Roles List');
        $this->page->setMetaDescription('A list of all Roles');

        //next add components, we assume the page already contains some components to only add to the content component.
        $contentTile = new componentEntity();
        $contentTile->name = 'GoHaulContentTile';
        $contentTile->props = (object)[
            "title" => 'Vehicle Type Manager',
            "content" => "In here you can make changes to the vehicle types. Remember any changes you make will update instantly on the website.",
            "help" => 'Please select the vehicle type from the list below you wish to update or create a new one.',
            "buttons" => [
                (object)[
                    "text" => 'Create New Vehicle Type',
                    "href" => '/vehicles/types/create',
                    "button" => 'btn-primary'
                ]
            ]
        ];

        $DataTable = new componentEntity();
        $DataTable->name = 'DataTable';
        $DataTable->addProperty('dataSrc', '/data/vehicles/types/list');


        $contentWrapper = new componentEntity();
        $contentWrapper->name = 'Content';
        $contentWrapper->classes = 'col-lg-10';
        $contentWrapper->addComponent($contentTile);
        $contentWrapper->addComponent($DataTable);

        $globalWrapper = $this->page->getComponent('ThePageContent');
        $globalWrapper->addComponent($contentWrapper);
        $this->page->replaceComponent('ThePageContent', $globalWrapper);

        return System::asJson($response, $this->page->getPage());
    }

    public function view(Request $request, Response $response, $args){
        if(!isset($args['ref'])){
            return System::asJson($response, ['message' => '404 not found'], 404);
        }
        $type = new vehicleTypeEntity();
        $type->load($args['ref']);

        if(!isset($type->ref)){
            return System::asJson($response, ['message' => '404 not found'], 404);
        }

        //First, we create the basic page
        $this->page->setMetaTitle($type->name);
        $this->page->setMetaDescription($type->name);

        //next add components, we assume the page already contains some components to only add to the content component.
        $contentTile = new componentEntity();
        $contentTile->name = 'GoHaulContentTile';
        $contentTile->props = (object)[
            "title" => $type->name,
            "content" => "",
            "buttons" => [
                (object)[
                    "text" => 'Edit This Vehicle Type',
                    "href" => '/vehicles/types/'.$type->ref.'/edit',
                    "button" => 'btn-primary'
                ],
                (object)[
                    "text" => 'Vehicle Type List',
                    "href" => '/vehicles/types',
                    "button" => 'btn-secondary'
                ],
                (object)[
                    "text" => 'Delete This Vehicle Type',
                    "href" => '/vehicles/types/'.$type->ref.'/delete',
                    "button" => 'btn-danger'
                ]
            ]
        ];

        $contentRows = [];
        $contentRows[] = ['Cost Per Mile', $type->cost_per_mile.'p'];

        $contentDetailsTable = new componentEntity();
        $contentDetailsTable->name = 'ContentTable';
        $contentDetailsTable->classes = 'col-md-4';
        $contentDetailsTable->title = 'Details';
        $contentDetailsTable->rows = $contentRows;

        $createdBy = new userEntity();
        $createdBy->load($type->created_user);

        $modifiedBy = new userEntity();
        $modifiedBy->load($type->modified_user);

        $contentRows = [];
        $contentRows[] = ['Created By', $createdBy->first_name.' '.$createdBy->last_name];
        $contentRows[] = ['Created Date', $type->created_date];
        $contentRows[] = ['Modified By', $modifiedBy->first_name.' '.$modifiedBy->last_name];
        $contentRows[] = ['Modified Date', $type->modified_date];

        $contentHistoryTable = new componentEntity();
        $contentHistoryTable->name = 'ContentTable';
        $contentHistoryTable->classes = 'col-md-4';
        $contentHistoryTable->title = 'History';
        $contentHistoryTable->rows = $contentRows;

        $rowWrapper = new componentEntity();
        $rowWrapper->name = 'RowWrapper';
        $rowWrapper->addComponent($contentDetailsTable);
        $rowWrapper->addComponent($contentHistoryTable);

        $contentWrapper = new componentEntity();
        $contentWrapper->name = 'Content';
        $contentWrapper->classes = 'col-lg-10';
        $contentWrapper->addComponent($contentTile);
        $contentWrapper->addComponent($rowWrapper);

        $globalWrapper = $this->page->getComponent('ThePageContent');
        $globalWrapper->addComponent($contentWrapper);
        $this->page->replaceComponent('ThePageContent', $globalWrapper);

        return System::asJson($response, $this->page->getPage());
    }

    public function create(Request $request, Response $response, $args){
        //First, we create the basic page
        $this->page->setMetaTitle('Create a Role');
        $this->page->setMetaDescription('Create a Role.');

        //next add components, we assume the page already contains some components to only add to the content component.
        $contentTile = new componentEntity();
        $contentTile->name = 'GoHaulContentTile';
        $contentTile->props = (object)[
            "title" => 'Create New Vehicle Type',
            "content" => "Please enter the details of your new vehicle type and click \"Submit\".",
            "buttons" => [
                (object)[
                    "text" => 'Vehicle Type List',
                    "href" => '/vehicles/types',
                    "button" => 'btn-secondary'
                ],
            ]
        ];

        $form = new componentEntity();
        $form->name = 'Form';
        $form->addProperty('dataSrc', '/data/vehicles/types/createForm');


        $contentWrapper = new componentEntity();
        $contentWrapper->name = 'Content';
        $contentWrapper->classes = 'col-lg-10';
        $contentWrapper->addComponent($contentTile);
        $contentWrapper->addComponent($form);

        $globalWrapper = $this->page->getComponent('ThePageContent');
        $globalWrapper->addComponent($contentWrapper);
        $this->page->replaceComponent('ThePageContent', $globalWrapper);

        return System::asJson($response, $this->page->getPage());
    }

    public function update(Request $request, Response $response, $args){
        //First, we create the basic page
        $type = new vehicleTypeEntity();
        $type->load($args['ref']);

        $this->page->setMetaTitle('Update '.$type->name);
        $this->page->setMetaDescription('Update '.$type->name);

        //next add components, we assume the page already contains some components to only add to the content component.
        $contentTile = new componentEntity();
        $contentTile->name = 'GoHaulContentTile';
        $contentTile->props = (object)[
            "title" => 'Edit '.$type->name,
            "content" => "Please change the vehicle type as required and click \"Submit\".",
            "buttons" => [
                (object)[
                    "text" => 'Create New Vehicle Type',
                    "href" => '/vehicles/types/create',
                    "button" => 'btn-primary'
                ],
                (object)[
                    "text" => 'Vehicle Type List',
                    "href" => '/vehicles/types',
                    "button" => 'btn-secondary'
                ],
            ]
        ];

        $form = new componentEntity();
        $form->name = 'Form';
        $form->addProperty('dataSrc', '/data/vehicles/types/'.$args['ref'].'/updateForm');

        $contentWrapper = new componentEntity();
        $contentWrapper->name = 'Content';
        $contentWrapper->classes = 'col-lg-10';
        $contentWrapper->addComponent($contentTile);
        $contentWrapper->addComponent($form);

        $globalWrapper = $this->page->getComponent('ThePageContent');
        $globalWrapper->addComponent($contentWrapper);
        $this->page->replaceComponent('ThePageContent', $globalWrapper);

        return System::asJson($response, $this->page->getPage());
    }

    public function manageForm(Request $request, Response $response, $args)
    {
        $types = FALSE;
        if (isset($args['ref'])) {
            $types = new vehicleTypeEntity();
            $types->load($args['ref']);
        }

        $form = new formEntity();
        $form->setId('manageVehicle');
        $form->setMethod('post');
        $form->setActionUrl('vehicles/types');
        if($types){
            $form->setActionUrl('vehicles/types/'.$args['ref']);
        }

        $name = (new inputField('name'))->setLabel('Name')->isRequired();
        if($types){
            $name->setValue($types->name);
        }
        $form->addField($name, 'details');

        $cost = (new inputField('cost'))->setLabel('Cost Per mile (pence)')->isRequired();
        if($types){
            $cost->setValue($types->cost);
        }
        $form->addField($cost, 'details');

        return System::asJson($response, $form->getBuiltFormArray());
    }

    public function dataTypesList($request, $response, $data){
        $params = $request->getQueryParams();

        $limit = isset($params['limit']) && !empty($params['limit']) ? $params['limit'] : 0;
        $offset = isset($params['offset']) && !empty($params['offset']) ? $params['offset'] : 0;

        $types = (new vehicleTypeEntity())->loadMultiple([], [], $limit, $offset);
        $totalResults = (new vehicleTypeEntity())->totalEntities();
        $totalPages = ceil (($totalResults/$params['limit']));
        $dataArray = [];
        foreach($types as $type){
            $entityData = (object)$type->getData();
            $data = (object)[
                "Ref" => $entityData->ref,
                "Name" => $entityData->name,
                "Cost per mile" => $entityData->cost_per_mile,
            ];
            $dataArray[] = $data;
        }
        $tableHeader = isset($dataArray[0]) ? array_keys((array)$dataArray[0]) : [];
        return System::asJson($response, ['rows' => $dataArray, 'totalData' => $totalResults, 'totalPages' => $totalPages, 'tableHeader' => $tableHeader]);
    }

    public function createUpdate($request, $response, $data){
        $type = new vehicleTypeEntity();
        if(isset($data['ref'])){
            $type->load($data['ref']);
        } else {
            $type->created_date = date('Y-m-d H:i:s');
            $type->created_user = $this->currentUser->id;
            $type->franchise = $this->currentUser->franchise;
        }
        $body = $request->getParsedBody();

        $type->name = $body->name;
        $type->cost_per_mile = $body->cost;

        $type->modified_date = date('Y-m-d H:i:s');
        $type->modified_user = $this->currentUser->id;

        if($type->isValid()){
            $type->store();
            return System::asJson($response, ['success' => 'true', 'redirectTo' => '/vehicles/types']);
        }

        return System::asJson($response, ['success' => 'false'], 400);
    }

    public function deleteView($request, $response, $data){
        //First, we create the basic page
        $type = new vehicleTypeEntity();
        if(isset($data['ref'])){
            $type->load($data['ref']);

            $this->page->setMetaTitle('Delete a Job');
            $this->page->setMetaDescription('Delete a Job.');

            //next add components, we assume the page already contains some components to only add to the content component.
            $contentTile = new componentEntity();
            $contentTile->name = 'GoHaulContentTile';
            $contentTile->props = (object)[
                "title" => 'Delete A Vehicle Type',
                "content" => "Are you sure you want to delete this Vehicle Type (".$type->name.")?",
                "buttons" => [
                    (object)[
                        "text" => 'Confirm Delete',
                        "href" => '/vehicles/types/'.$type->ref,
                        "button" => 'btn-danger',
                        "type" => "delete"
                    ],
                ]
            ];

            $contentWrapper = new componentEntity();
            $contentWrapper->name = 'Content';
            $contentWrapper->classes = 'col-lg-10';
            $contentWrapper->addComponent($contentTile);

            $globalWrapper = $this->page->getComponent('ThePageContent');
            $globalWrapper->addComponent($contentWrapper);
            $this->page->replaceComponent('ThePageContent', $globalWrapper);

            return System::asJson($response, $this->page->getPage());
        } else {
            return System::asJson($response, ['success' => 'false'], 404);
        }
    }

    public function delete($request, $response, $data){
        (new vehicleTypeEntity())->delete($data['ref']);
        return System::asJson($response, ['success' => 'true', 'redirectTo' => '/vehicles/types']);
    }
}