<?php

namespace apexl\Io\modules\gohaul\controllers;

use apexl\Io\includes\System;
use apexl\Io\modules\component\entities\componentEntity;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\checkboxField;
use apexl\Io\modules\formbuilder\includes\inputField;
use apexl\Io\modules\formbuilder\includes\selectField;
use apexl\Io\modules\page\services\Page;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\entities\vehicleEntity;
use apexl\Io\modules\user\entities\vehicleTypeEntity;
use apexl\Io\modules\user\services\currentUser;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class vehiclesController{

    protected $page;
    /** @var userEntity */
    protected $currentUser;
    public function __construct(Page $page, currentUser $currentUser){
        $this->page = $page;
        $this->currentUser = $currentUser::getCurrentUser();
    }

    public function list(Request $request, Response $response, $args){
        //First, we create the basic page
        $this->page->setMetaTitle('View Vehicle List');
        $this->page->setMetaDescription('A list of all created Vehicles.');

        //next add components, we assume the page already contains some components to only add to the content component.
        $contentTile = new componentEntity();
        $contentTile->name = 'GoHaulContentTile';
        $contentTile->props = (object)[
            "title" => 'Vehicle Manager',
            "content" => "In here you can make changes to the vehicles. Remember any changes you make will update instantly on the website.",
            "help" => 'Please select the vehicle from the list below you wish to update or create a new one.',
            "buttons" => [
                (object)[
                    "text" => 'Create New Vehicle',
                    "href" => '/vehicles/create',
                    "button" => 'btn-primary'
                ]
            ]
        ];

        $DataTable = new componentEntity();
        $DataTable->name = 'DataTable';
        $DataTable->addProperty('dataSrc', '/data/vehicles/list');


        $contentWrapper = new componentEntity();
        $contentWrapper->name = 'Content';
        $contentWrapper->classes = 'col-lg-10';
        $contentWrapper->addComponent($contentTile);
        $contentWrapper->addComponent($DataTable);

        $globalWrapper = $this->page->getComponent('ThePageContent');
        $globalWrapper->addComponent($contentWrapper);
        $this->page->replaceComponent('ThePageContent', $globalWrapper);

        return System::asJson($response, $this->page->getPage());
    }

    public function view(Request $request, Response $response, $args){
        if(!isset($args['ref'])){
            return System::asJson($response, ['message' => '404 not found'], 404);
        }
        $vehicle = new vehicleEntity();
        $vehicle->load($args['ref']);

        if(!isset($vehicle->ref)){
            return System::asJson($response, ['message' => '404 not found'], 404);
        }

        //First, we create the basic page
        $this->page->setMetaTitle('Vehicle '.$vehicle->registration);
        $this->page->setMetaDescription('Vehicle '.$vehicle->registration);

        $vehicleType = new vehicleTypeEntity();
        $vehicleType->load($vehicle->vehicle_type);
        //next add components, we assume the page already contains some components to only add to the content component.
        $contentTile = new componentEntity();
        $contentTile->name = 'GoHaulContentTile';
        $contentTile->props = (object)[
            "title" => $vehicle->registration.' ('.$vehicleType->name.')',
            "content" => "",
            "buttons" => [
                (object)[
                    "text" => 'Edit This Vehicle',
                    "href" => '/vehicles/'.$vehicle->ref.'/edit',
                    "button" => 'btn-primary'
                ],
                (object)[
                    "text" => 'Create New Vehicle',
                    "href" => '/vehicles/create',
                    "button" => 'btn-primary'
                ],
                (object)[
                    "text" => 'Delete This Vehicle',
                    "href" => '/vehicles/'.$vehicle->ref.'/delete',
                    "button" => 'btn-danger'
                ]
            ]
        ];

        $contentRows = [];
        $contentRows[] = ['Registration', $vehicle->registration];
        $contentRows[] = ['Vehicle Type', $vehicleType->name];
        $contentRows[] = ['Cost Per Mile', $vehicleType->cost_per_mile.'p'];
        $contentRows[] = ['Available', $vehicle->available ? 'Yes' : 'No'];

        $contentDetailsTable = new componentEntity();
        $contentDetailsTable->name = 'ContentTable';
        $contentDetailsTable->classes = 'col-md-4';
        $contentDetailsTable->title = 'Details';
        $contentDetailsTable->rows = $contentRows;

        $createdUser = new userEntity();
        $createdUser->load($vehicle->created_user);

        $modifiedUser = new userEntity();
        $modifiedUser->load($vehicle->modified_user);

        $contentRows = [];
        $contentRows[] = ['Created By', $createdUser->first_name.' '.$createdUser->last_name];
        $contentRows[] = ['Created Date', $vehicle->created_date];
        $contentRows[] = ['Modified By', $modifiedUser->first_name.' '.$modifiedUser->last_name];
        $contentRows[] = ['Modified Date', $vehicle->modified_date];

        $contentHistoryTable = new componentEntity();
        $contentHistoryTable->name = 'ContentTable';
        $contentHistoryTable->classes = 'col-md-4';
        $contentHistoryTable->title = 'History';
        $contentHistoryTable->rows = $contentRows;

        $rowWrapper = new componentEntity();
        $rowWrapper->name = 'RowWrapper';
        $rowWrapper->addComponent($contentDetailsTable);
        $rowWrapper->addComponent($contentHistoryTable);

        $contentWrapper = new componentEntity();
        $contentWrapper->name = 'Content';
        $contentWrapper->classes = 'col-lg-10';
        $contentWrapper->addComponent($contentTile);
        $contentWrapper->addComponent($rowWrapper);

        $globalWrapper = $this->page->getComponent('ThePageContent');
        $globalWrapper->addComponent($contentWrapper);
        $this->page->replaceComponent('ThePageContent', $globalWrapper);

        return System::asJson($response, $this->page->getPage());
    }

    public function create(Request $request, Response $response, $args){
        //First, we create the basic page
        $this->page->setMetaTitle('Create a Vehicle');
        $this->page->setMetaDescription('Create a Vehicle.');

        //next add components, we assume the page already contains some components to only add to the content component.
        $contentTile = new componentEntity();
        $contentTile->name = 'GoHaulContentTile';
        $contentTile->props = (object)[
            "title" => 'Create New User',
            "content" => "Please enter the details of your new user and click \"Submit\".",
            "buttons" => [
                (object)[
                    "text" => 'Vehicle List',
                    "href" => '/vehicles',
                    "button" => 'btn-secondary'
                ],
            ]
        ];

        $form = new componentEntity();
        $form->name = 'Form';
        $form->addProperty('dataSrc', '/data/vehicles/createForm');


        $contentWrapper = new componentEntity();
        $contentWrapper->name = 'Content';
        $contentWrapper->classes = 'col-lg-10';
        $contentWrapper->addComponent($contentTile);
        $contentWrapper->addComponent($form);

        $globalWrapper = $this->page->getComponent('ThePageContent');
        $globalWrapper->addComponent($contentWrapper);
        $this->page->replaceComponent('ThePageContent', $globalWrapper);

        return System::asJson($response, $this->page->getPage());
    }

    public function update(Request $request, Response $response, $args){
        //First, we create the basic page
        $vehicle = new vehicleEntity();
        $vehicle->load($args['ref']);

        $vehicleType = new vehicleTypeEntity();
        $vehicleType->load($vehicle->vehicle_type);

        $this->page->setMetaTitle('Update a Vehicle');
        $this->page->setMetaDescription('Update a Vehicle.');

        //next add components, we assume the page already contains some components to only add to the content component.
        $contentTile = new componentEntity();
        $contentTile->name = 'GoHaulContentTile';
        $contentTile->props = (object)[
            "title" => $vehicle->registration.' ('.$vehicleType->name.')',
            "content" => "Please change the vehicle as required and click \"Submit\".",
            "buttons" => [
                (object)[
                    "text" => 'Create New Vehicle',
                    "href" => '/vehicles/create',
                    "button" => 'btn-primary'
                ],
                (object)[
                    "text" => 'Vehicle List',
                    "href" => '/vehicles',
                    "button" => 'btn-secondary'
                ],
            ]
        ];

        $form = new componentEntity();
        $form->name = 'Form';
        $form->addProperty('dataSrc', '/data/vehicles/'.$args['ref'].'/updateForm');


        $contentWrapper = new componentEntity();
        $contentWrapper->name = 'Content';
        $contentWrapper->classes = 'col-lg-10';
        $contentWrapper->addComponent($contentTile);
        $contentWrapper->addComponent($form);

        $globalWrapper = $this->page->getComponent('ThePageContent');
        $globalWrapper->addComponent($contentWrapper);
        $this->page->replaceComponent('ThePageContent', $globalWrapper);

        return System::asJson($response, $this->page->getPage());
    }

    public function manageForm(Request $request, Response $response, $args)
    {
        $vehicle = FALSE;
        if (isset($args['ref'])) {
            $vehicle = new vehicleEntity();
            $vehicle->load($args['ref']);
        }

        $form = new formEntity();
        $form->setId('manageVehicle');
        $form->setMethod('post');
        $form->setActionUrl('vehicles');
        if($vehicle){
            $form->setActionUrl('vehicles/'.$args['ref']);
        }

        $registration = (new inputField('registration'))->setLabel('Registration')->isRequired();
        if($vehicle){
            $registration->setValue($vehicle->registration);
        }
        $form->addField($registration, 'details');
        $types = (new vehicleTypeEntity())->loadMultiple();
        //callback returns cost and vehicle information.
        $typesField = (new selectField('vehicle_type'))->buildOptionsFromEntities($types, 'ref', 'name')->setLabel('Vehicle Type')->isRequired();
        if($vehicle){
            $typesField->setValue($vehicle->vehicle_type);
        }
        $form->addField($typesField, 'details');

        $available = (new checkboxField('available'))->setLabel('Available');
        if($vehicle && $vehicle->available){
            $available->setValue($vehicle->available);
        }
        $form->addField($available, 'details');

        return System::asJson($response, $form->getBuiltFormArray());
    }

    public function dataVehiclesList($request, $response, $data){
        $params = $request->getQueryParams();

        $limit = isset($params['limit']) && !empty($params['limit']) ? $params['limit'] : 0;
        $offset = isset($params['offset']) && !empty($params['offset']) ? $params['offset'] : 0;

        $vehicles = (new vehicleEntity())->loadMultiple([], [], $limit, $offset);
        $totalResults = (new vehicleEntity())->totalEntities();
        $totalPages = ceil (($totalResults/$params['limit']));
        $dataArray = [];
        foreach($vehicles as $vehicle){
            $entityData = (object)$vehicle->getData();
            $type = new vehicleTypeEntity();
            $type->load($vehicle->vehicle_type);

            $data = (object)[
                "Ref" => $entityData->ref,
                "Registration" => $entityData->registration,
                "Vehicle Type" => $type->name,
                "Available" => $entityData->available,
                "Created" => $entityData->created_date,
            ];
            $dataArray[] = $data;
        }
        $tableHeader = isset($dataArray[0]) ? array_keys((array)$dataArray[0]) : [];
        return System::asJson($response, ['rows' => $dataArray, 'totalData' => $totalResults, 'totalPages' => $totalPages, 'tableHeader' => $tableHeader]);
    }

    public function createUpdate($request, $response, $data){
        $vehicle = new vehicleEntity();
        if(isset($data['ref'])){
            $vehicle->load($data['ref']);
        } else {
            $vehicle->created_date = date('Y-m-d H:i:s');
            $vehicle->created_user = $this->currentUser->id;
            $vehicle->franchise = $this->currentUser->franchise;
        }
        $body = $request->getParsedBody();

        $vehicle->registration = $body->registration;
        $vehicle->vehicle_type = $body->vehicle_type;
        $vehicle->available = $body->available;

        $vehicle->modified_date = date('Y-m-d H:i:s');
        $vehicle->modified_user = $this->currentUser->id;

        if($vehicle->isValid()){
            $vehicle->store();
            return System::asJson($response, ['success' => 'true', 'redirectTo' => '/vehicles']);
        }
        return System::asJson($response, ['success' => 'false'], 400);
    }

    public function deleteView($request, $response, $data){
        //First, we create the basic page
        $vehicle = new vehicleEntity();
        if(isset($data['ref'])){
            $vehicle->load($data['ref']);

            $this->page->setMetaTitle('Delete a Job');
            $this->page->setMetaDescription('Delete a Job.');

            //next add components, we assume the page already contains some components to only add to the content component.
            $contentTile = new componentEntity();
            $contentTile->name = 'GoHaulContentTile';
            $contentTile->props = (object)[
                "title" => 'Delete A Vehicle',
                "content" => "Are you sure you want to delete this Vehicle (".$vehicle->registration.")?",
                "buttons" => [
                    (object)[
                        "text" => 'Confirm Delete',
                        "href" => '/vehicles/'.$vehicle->ref,
                        "button" => 'btn-danger',
                        "type" => "delete"
                    ],
                ]
            ];

            $contentWrapper = new componentEntity();
            $contentWrapper->name = 'Content';
            $contentWrapper->classes = 'col-lg-10';
            $contentWrapper->addComponent($contentTile);

            $globalWrapper = $this->page->getComponent('ThePageContent');
            $globalWrapper->addComponent($contentWrapper);
            $this->page->replaceComponent('ThePageContent', $globalWrapper);

            return System::asJson($response, $this->page->getPage());
        } else {
            return System::asJson($response, ['success' => 'false'], 404);
        }
    }

    public function delete($request, $response, $data){
        (new vehicleEntity())->delete($data['ref']);
        return System::asJson($response, ['success' => 'true', 'redirectTo' => '/vehicles']);
    }
}