<?php

namespace apexl\Io\modules\user\entities;

use apexl\Io\includes\Entity;
use apexl\Io\modules\user\entities\operators\companyOperator;
use apexl\Io\operators\entityDatabaseOperator;

class companiesEntity extends Entity {
    /** @var companyOperator */
    protected $operator;

    public function __construct()
    {
        parent::__construct('companies', 'ref', 'franchise', 'franchise');
        $this->setOperator(new companyOperator('companies', 'ref'));
        $this->changeAccessCheckStatus(FALSE);
    }

    public function getOutstandingPos(){
        return $this->operator->getOutstandingPos($this->ref);
    }
}