<?php

namespace apexl\Io\modules\user\entities;

use apexl\Io\includes\Entity;
use apexl\Io\modules\user\entities\operators\jobOperator;
use apexl\Io\operators\entityDatabaseOperator;

class jobEntity extends Entity {
    public function __construct()
    {
        parent::__construct('jobs', 'ref', 'franchise', 'franchise');
        $this->setOperator(new jobOperator('jobs', 'ref'));
    }

    public function load($id){
        $load = parent::__call('load', [$id]);
        $this->setStatusValue();
        return $load;
    }

    public function store(){
        $status = $this->status;
        //remove to avoid DB errors
        unset($this->status);
        parent::__call('store', [$this->data]);
        //re-add it as the object still might be used.
        $this->status = $status;
    }

    public function setData($entity){
        parent::setData($entity);
        $this->setStatusValue();
    }

    protected function setStatusValue(){
        $this->status = $this->statusValues();
    }

    protected function convertStatusCondition()
    {

    }

    protected function statusValues(){
        switch(TRUE){
            case !empty($this->completed_date):
                return 'Complete';
                break;
            case !is_null($this->invoiced_amount) && (is_null($this->amount_paid) || $this->amount_paid < $this->invoiced_amount):
                return 'Invoiced';
                break;
            case !empty($this->confirmed_date):
                return 'Ready to be invoiced';
                break;
            case is_null($this->invoiced_amount):
                return 'Not Invoiced';
                break;
            case strtotime($this->job_date) > time():
                return 'Pending';
                break;
            case strtotime($this->job_date) == strtotime(date('Y-m-d')):
                return 'Ongoing';
                break;
            case strtotime($this->job_date) < strtotime(date('Y-m-d')):
                return 'Overdue';
                break;
            case $this->amount_paid >= $this->invoiced_amount:
                return 'Paid';
                break;
        }
        return 'Unknown';
    }
}