<?php

namespace apexl\Io\modules\user\entities\operators;

use apexl\Io\operators\entityDatabaseOperator;

class companyOperator extends entityDatabaseOperator{
    public function __construct($table, $primaryKey = 'id')
    {
        parent::__construct($table, $primaryKey);
    }

    /**
     * @param $company
     * @return int
     */
    public function getOutstandingPos($company){
        $rows = $this->vault
            ->select('companies')
            ->fields()
            ->join('jobs', 'companies.ref', 'company')
            ->join('purchase_orders', 'jobs.purchase_order', 'purchase_orders.ref')
            ->where('jobs.amount_paid', 0, '>')
            ->where('companies.ref', $company)
            ->execute()
            ->fetchAll();

        $outstanding = 0;
        foreach($rows as $row){
            $outstanding = $outstanding + $row->cost;
        }

        return $outstanding;
    }
}