<?php

namespace apexl\Io\modules\user\entities\operators;

use apexl\Io\modules\user\services\currentUser;
use apexl\Io\operators\entityDatabaseOperator;
use apexl\Io\services\globalData;
use function GuzzleHttp\Psr7\str;

class jobOperator extends entityDatabaseOperator{
    public function __construct($table, $primaryKey = 'id')
    {
        parent::__construct($table, $primaryKey);
    }

    public function loadByPo($po){
        $entity = $this->vault->select($this->dbTable)->fields()->where('purchase_order', $po)->execute()->fetchAssoc();
        return ['updateEntityData' => true, 'data' => $entity];
    }

    public function loadWeeklyJobsByDriver($startOfWeek){
        $endOfWeek = date('Y-m-d',strtotime('next sunday', strtotime($startOfWeek)));
        $currentUser = (globalData::getInstance())->getData()['user'];
        return $this->vault->select($this->dbTable)
            ->fields()
            //->where('driver', 'null', 'IS NOT NULL')
            ->where('franchise', $currentUser->franchise)
            ->where('job_date', $startOfWeek, '>=')
            ->where('job_date', $endOfWeek, '<=')
            ->groupBy('job_date, ref', 'ASC')
            ->execute()
            ->fetchAll();
    }

    public function isInvoiced(){
        $currentUser = (globalData::getInstance())->getData()['user'];
        return $this->vault->select($this->dbTable)
            ->fields()
            ->where('invoiced_amount', NULL, 'IS NOT', 'AND (')
            ->where('amount_paid', 'NULL', 'IS', 'OR')
            ->where('amount_paid', 'invoiced_amount', '<', 'OR', ')')
            ->where('franchise', $currentUser->franchise)
            ->execute()
            ->fetchAll();
    }
}