<?php

namespace apexl\Io\modules\user\entities\operators;

use apexl\Io\operators\entityDatabaseOperator;

class poOperator extends entityDatabaseOperator{
    public function __construct($table, $primaryKey = 'id')
    {
        parent::__construct($table, $primaryKey);
    }

    public function loadUnassigned($franchiseId){
        $entity = $this->vault->select($this->dbTable)->fields(['purchase_orders.ref'])
            ->leftJoin('jobs', 'jobs.purchase_order', 'purchase_orders.ref')
            ->where('jobs.purchase_order', '', 'IS NULL')
            ->where('purchase_orders.franchise', $franchiseId)
            ->orderBy('purchase_orders.ref', 'DESC')
            ->execute()
            ->fetchAll();
        return ['updateEntityData' => true, 'data' => $entity];
    }

    public function loadMultiple($conditions = [], $orderBy = [], $limit = FALSE, $offset = FALSE){
        $query = $this->vault->select($this->dbTable)->fields([
            'purchase_orders.*',
        ])->leftJoin('jobs', 'jobs.purchase_order', 'purchase_orders.ref');
        foreach($conditions as $condition){
            $operator = $condition[2] ?? '=';
            $type = $condition[3] ?? 'AND';
            $postCondition = $condition[4] ?? '';
            $query->where($condition[0], $condition[1], $operator, $type, $postCondition);
        }
        if(!empty($orderBy)){
            $direction = $orderBy[1] ?? 'DESC';
            $query->orderBy($orderBy[0], $direction);
        }
        if($limit !== FALSE){
            $query->limit($limit, $offset);
        }
        return $query->execute()->fetchAll();
    }

    public function loadAssigned($conditions = [], $orderBy = [], $limit = FALSE, $offset = FALSE){
        $query = $this->vault->select($this->dbTable)->fields(
            [
                "purchase_orders.ref AS ref",
                "jobs.ref AS job_ref",
                "jobs.job_date AS job_date",
                "purchase_orders.collection AS collection",
                "purchase_orders.delivery AS delivery",
                "purchase_orders.haulier AS haulier",
                "purchase_orders.their_price AS their_price",
                "purchase_orders.our_price AS our_price",
                "jobs.invoiced_amount AS invoiced_amount",
                "jobs.amount_paid AS amount_paid",
                "purchase_orders.created_user AS created_user",
                "purchase_orders.created_date AS created_date",
                "purchase_orders.franchise AS franchise",
            ]
        )
            ->join('jobs', 'jobs.purchase_order', 'purchase_orders.ref');
        foreach($conditions as $condition){
            $operator = $condition[2] ?? '=';
            $type = $condition[3] ?? 'AND';
            $postCondition = $condition[4] ?? '';
            $query->where($condition[0], $condition[1], $operator, $type, $postCondition);
        }
        if(!empty($orderBy)){
            $direction = $orderBy[1] ?? 'DESC';
            $query->orderBy($orderBy[0], $direction);
        }
        if($limit !== FALSE){
            $query->limit($limit, $offset);
        }
        return $query->execute()->fetchAll();
    }
}