<?php

namespace apexl\Io\modules\user\entities;

use apexl\Io\includes\Entity;
use apexl\Io\includes\System;
use apexl\Io\modules\user\entities\operators\poOperator;
use apexl\Io\services\globalData;

class purchaseOrderEntity extends Entity {
    public function __construct()
    {
        parent::__construct('purchase_orders', 'ref', 'franchise', 'franchise');
        $this->setOperator(new poOperator('purchase_orders', 'ref'));
    }

    /**
     * Overridden base method to define franchise table in where clause.
     * @param array $conditions
     * @param array $orderBy
     * @param bool $limit
     * @param bool $offset
     * @return array
     * @throws \Exception
     */
    public function loadMultiple($conditions = [], $orderBy = [], $limit = FALSE, $offset = FALSE){
        $loaded = [];
        if(class_exists('\apexl\Io\modules\user\userModule') && $this->performAccessChecks){
            $user = (globalData::getInstance())->getData()['user'];
            $conditions = array_merge([$this->ownershipField => ['purchase_orders.'.$this->ownershipField, $user->{$this->userAccessField}]], $conditions);
        }
        $results = parent::__call('loadMultiple', [$conditions, $orderBy, $limit, $offset]);
        //build objects
        if(!empty($results)){
            foreach ($results as $result){
                $entityType = get_called_class();
                //set entity data (prevents us from having to reload entities)
                $entity = new $entityType();
                $entity->setData(System::makeUTF8Safe($result));
                //build an array of loaded entities
                $loaded[$entity->{$this->primaryKey}] = $entity;
            }
        }
        return $loaded;
    }

    public function loadAssigned($conditions = [], $orderBy = [], $limit = FALSE, $offset = FALSE){
        $loaded = [];
        if(class_exists('\apexl\Io\modules\user\userModule') && $this->performAccessChecks){
            $user = (globalData::getInstance())->getData()['user'];
            $conditions = array_merge([$this->ownershipField => ['purchase_orders.'.$this->ownershipField, $user->{$this->userAccessField}]], $conditions);
        }
        $results = parent::__call('loadAssigned', [$conditions, $orderBy, $limit, $offset]);
        //build objects
        if(!empty($results)){
            foreach ($results as $result){
                $entityType = get_called_class();
                //set entity data (prevents us from having to reload entities)
                $entity = new $entityType();
                $entity->setData(System::makeUTF8Safe($result));
                //build an array of loaded entities
                $loaded[$entity->{$this->primaryKey}] = $entity;
            }
        }
        return $loaded;
    }

    public function totalEntities(){
        if(class_exists('\apexl\Io\modules\user\userModule') && $this->performAccessChecks){
            $user = (globalData::getInstance())->getData()['user'];
            $conditions = [$this->ownershipField => ['purchase_orders.'.$this->ownershipField, $user->{$this->userAccessField}]];
        }
        return count(parent::__call('loadAssigned', [$conditions]));
    }
}