<?php

namespace apexl\Io\modules\gohaul;

use apexl\Io\includes\Module;
use apexl\Io\middleware\goHaul\goHaulController;
use apexl\Io\modules\gohaul\controllers\AmazonJobImportController;
use apexl\Io\modules\gohaul\controllers\companiesController;
use apexl\Io\modules\gohaul\controllers\contactsController;
use apexl\Io\modules\gohaul\controllers\defectController;
use apexl\Io\modules\gohaul\controllers\documentsController;
use apexl\Io\modules\gohaul\controllers\franchiseController;
use apexl\Io\modules\gohaul\controllers\homeController;
use apexl\Io\modules\gohaul\controllers\jobsController;
use apexl\Io\modules\gohaul\controllers\posController;
use apexl\Io\modules\gohaul\controllers\rolesController;
use apexl\Io\modules\gohaul\controllers\driverController;
use apexl\Io\modules\gohaul\controllers\typesController;
use apexl\Io\modules\gohaul\controllers\usersController;
use apexl\Io\modules\gohaul\controllers\vehiclesController;
use apexl\Io\modules\user\services\Permissions;

/**
 * Base module file, provides required methods to register things like routes and middleware.
 * Class installModule
 * @package apexl\Io\modules\install
 */
class gohaulModule extends Module {

    public function __construct()
    {
        parent::__construct();
    }

    public function addMiddleware(){
        $this->Io->add(goHaulController::class);
    }

    public function registerPermissions(Permissions $permissions){

        $permissions->registerPermission('ManageOwnAccount', 'Manage own User Account', 'Users');

        $permissions->registerPermission('ViewJobs', 'View Jobs', 'Jobs');
        $permissions->registerPermission('CreateJobs', 'Create Jobs', 'Jobs');
        $permissions->registerPermission('UpdateJobs', 'Update Jobs', 'Jobs');
        $permissions->registerPermission('DeleteJobs', 'Delete Jobs', 'Jobs');

        $permissions->registerPermission('MarkJobDelivered', 'Change Job Delivery State', 'Jobs');

        $permissions->registerPermission('ViewPOs', 'View POs', 'Purchase orders');
        $permissions->registerPermission('ViewPOsStatus', 'View POs Status', 'Purchase orders');
        $permissions->registerPermission('CreatePOs', 'Create POs', 'Purchase orders');
        $permissions->registerPermission('UpdatePOs', 'Update POs', 'Purchase orders');
        $permissions->registerPermission('DeletePOs', 'Delete POs', 'Purchase orders');

        $permissions->registerPermission('ViewCompanies', 'View Companies', 'Companies');
        $permissions->registerPermission('CreateCompanies', 'Create Companies', 'Companies');
        $permissions->registerPermission('UpdateCompanies', 'Update Companies', 'Companies');
        $permissions->registerPermission('DeleteCompanies', 'Delete Companies', 'Companies');

        $permissions->registerPermission('ViewContacts', 'View Contacts', 'Contacts');
        $permissions->registerPermission('CreateContacts', 'Create Contacts', 'Contacts');
        $permissions->registerPermission('UpdateContacts', 'Update Contacts', 'Contacts');
        $permissions->registerPermission('DeleteContacts', 'Delete Contacts', 'Contacts');

        $permissions->registerPermission('ViewVehicles', 'View Vehicles', 'Vehicles');
        $permissions->registerPermission('CreateVehicles', 'Create Vehicles', 'Vehicles');
        $permissions->registerPermission('UpdateVehicles', 'Update Vehicles', 'Vehicles');
        $permissions->registerPermission('DeleteVehicles', 'Delete Vehicles', 'Vehicles');

        $permissions->registerPermission('ViewTypes', 'View Types', 'Vehicle Types');
        $permissions->registerPermission('CreateTypes', 'Create Types', 'Vehicle Types');
        $permissions->registerPermission('UpdateTypes', 'Update Types', 'Vehicle Types');
        $permissions->registerPermission('DeleteTypes', 'Delete Types', 'Vehicle Types');

        $permissions->registerPermission('ViewDocuments', 'View Documents', 'Documents');
        $permissions->registerPermission('CreateDocuments', 'Create Documents', 'Documents');
        $permissions->registerPermission('UpdateDocuments', 'Update Documents', 'Documents');
        $permissions->registerPermission('DeleteDocuments', 'Delete Documents', 'Documents');

        $permissions->registerPermission('ViewFranchises', 'View Franchises', 'Franchises');
        $permissions->registerPermission('CreateFranchises', 'Create Franchises', 'Franchises');
        $permissions->registerPermission('UpdateFranchises', 'Update Franchises', 'Franchises');
        $permissions->registerPermission('DeleteFranchises', 'Delete Franchises', 'Franchises');

        $permissions->registerPermission('AssignDriver', 'Assign Driver', 'Roles');
        $permissions->registerPermission('ImportAmazon', 'Import Amazon Jobs', 'Imports');

        $permissions->registerPermission('createDefects', 'Create Defects', 'Defects');
        $permissions->registerPermission('viewDefects', 'View Defects', 'Defects');
    }

    public function routes(){
        $this->homeRoute();
        $this->jobsRoutes();
        $this->poRoutes();
        $this->companyRoutes();
        $this->contactRoutes();
        $this->accountRoutes();
        $this->rolesRoutes();
        $this->franchiseRoutes();
        $this->vehicleTypesRoutes();
        $this->vehicleRoutes();
        $this->documentRoutes();
        $this->registerDriverRoutes();
        $this->importRoutes();
        $this->defectRoutes();
    }

    protected function registerDriverRoutes()
    {
        $this->route->get('/api/driver/jobs', driverController::class.':jobList', 'IsLoggedIn');
    }

    protected function homeRoute(){
        $this->route->get('/', homeController::class.':dashboard', 'IsLoggedIn')->addToMenu('Home', 'home');
    }

    protected function jobsRoutes(){
        $this->route->get('/jobsParent', jobsController::class.':list', 'ViewJobs')->addToMenu("Jobs", "briefcase");
        $this->route->get('/jobs', jobsController::class.':list', 'ViewJobs')->addToMenu("View Jobs", "", '/jobsParent');
        $this->route->get('/data/jobs/list', jobsController::class.':dataJobsList', 'ViewJobs', FALSE);
        $this->route->get('/data/jobs/simpleList', jobsController::class.':dataJobsListSimple', 'ViewJobs', FALSE);
        $this->route->get('/data/jobs/filterForm', jobsController::class.':filterForm', 'ViewJobs', FALSE);

        $this->route->get('/jobs/create', jobsController::class.':create', 'CreateJobs')->addToMenu("Create A Job", "", '/jobsParent');
        $this->route->get('/data/jobs/createForm', jobsController::class.':manageForm', 'CreateJobs', FALSE);

        $this->route->get('/jobs/{ref}/invoice', jobsController::class.':invoice', 'CreateJobs');
        $this->route->get('/jobs/{ref}/edit', jobsController::class.':update', 'UpdateJobs');
        $this->route->get('/jobs/{ref}/delete', jobsController::class.':deleteView', 'DeleteJobs');
        $this->route->get('/jobs/{ref}', jobsController::class.':view', 'ViewJobs');
        $this->route->get('/data/job/{ref}/updateForm', jobsController::class.':manageForm', 'UpdateJobs', FALSE);

        $this->route->get('/jobs/callbacks/typeSelected/{type}', jobsController::class.':typeSelectedCallback', 'CreateJobs', FALSE);

        $this->route->get('/data/jobs/{ref}/jobAttachmentsForm', jobsController::class.':jobAttachmentsForm', 'CreateJobs', FALSE);
        $this->route->get('/data/jobs/{ref}/jobAttachmentsData', jobsController::class.':jobAttachmentsData', 'ViewJobs', FALSE);
        $this->route->post('/data/jobs/{ref}/saveFile', jobsController::class.':jobAttachmentsSave', 'UpdateJobs', FALSE);
        $this->route->post('/jobs/attachments/{ref}', jobsController::class.':jobAttachmentsSaveComplete', 'UpdateJobs', FALSE);

        $this->route->post('/jobs', jobsController::class.':createUpdate', 'CreateJobs', FALSE);
        $this->route->post('/jobs/{ref}', jobsController::class.':createUpdate', 'CreateJobs', FALSE);
        $this->route->delete('/jobs/{ref}', jobsController::class.':delete', 'DeleteJobs', FALSE);

        $this->route->get('/invoices/sync', jobsController::class.':syncInvoices', 'CreateJobs');

        $this->route->get('/api/jobs/{ref}', jobsController::class.':apiJob', 'ViewJobs', false);
        $this->route->post('/api/jobs/{ref}/saveFile', jobsController::class.':apiJobImage', 'ViewJobs', false);
        $this->route->post('/api/jobs/{ref}', jobsController::class.':apiJobUpdate', 'ViewJobs', false);
    }

    protected function poRoutes(){
        $this->route->get('/posParent', posController::class.':list', 'ViewPOs')->addToMenu("POs", "money-check");
        $this->route->get('/pos', posController::class.':list', 'ViewPOs')->addToMenu("View POs", "", '/posParent');
        $this->route->get('/pos/status', posController::class.':status', 'ViewPOsStatus')->addToMenu("View POs", "", '/posParent');
        $this->route->get('/data/pos/list', posController::class.':dataPosList', 'ViewPOs', FALSE);
        $this->route->get('/data/pos/filterForm', posController::class.':filterForm', 'ViewPOs', FALSE);
        $this->route->get('/data/pos/status/{band}/{franchise}', posController::class.':statusData', 'ViewPOsStatus', FALSE);

        $this->route->get('/pos/create', posController::class.':create', 'CreatePOs')->addToMenu("Create A Job", "", '/posParent');
        $this->route->get('/data/pos/createForm', posController::class.':manageForm', 'CreatePOs', FALSE);

        $this->route->get('/pos/{ref}/edit', posController::class.':update', 'UpdatePOs');
        $this->route->get('/pos/{ref}/clone', posController::class.':clone', 'CreatePOs');
        $this->route->get('/pos/{ref}', posController::class.':view', 'ViewPOs');
        $this->route->get('/pos/{ref}/delete', posController::class.':deleteView', 'DeletePOs');
        $this->route->get('/data/pos/{ref}/updateForm', posController::class.':manageForm', 'UpdatePOs', FALSE);

        $this->route->post('/pos', posController::class.':createUpdate', 'CreatePOs', FALSE);
        $this->route->post('/pos/{ref}', posController::class.':createUpdate', 'CreatePOs', FALSE);
        $this->route->delete('/pos/{ref}', posController::class.':delete', 'DeletePOs', FALSE);
    }

    protected function companyRoutes(){
        $this->route->get('/companiesParent', companiesController::class.':list', 'ViewCompanies')->addToMenu("Companies", "money-check");
        $this->route->get('/companies', companiesController::class.':list', 'ViewCompanies')->addToMenu("View Companies", "", '/companiesParent');
        $this->route->get('/data/companies/list', companiesController::class.':dataCompaniesList', 'ViewCompanies', FALSE);
        $this->route->get('/data/companies/filterForm', companiesController::class.':filterForm', 'ViewCompanies', FALSE);

        $this->route->get('/companies/create', companiesController::class.':create', 'CreateCompanies')->addToMenu("Create A Company", "", '/companiesParent');
        $this->route->get('/data/companies/createForm', companiesController::class.':manageForm', 'CreateCompanies', FALSE);

        $this->route->get('/companies/{ref}/edit', companiesController::class.':update', 'UpdateCompanies');
        $this->route->get('/companies/{ref}/delete', companiesController::class.':deleteView', 'DeleteCompanies');
        $this->route->get('/companies/{ref}', companiesController::class.':view', 'ViewCompanies');
        $this->route->get('/data/companies/{ref}/updateForm', companiesController::class.':manageForm', 'UpdateCompanies', FALSE);
        $this->route->get('/data/companies/{ref}/job/list', companiesController::class.':jobList', 'ViewCompanies', FALSE);
        $this->route->get('/data/companies/{ref}/contacts/list', companiesController::class.':contactList', 'ViewCompanies', FALSE);

        $this->route->post('/companies', companiesController::class.':createUpdate', 'CreateCompanies', FALSE);
        $this->route->post('/companies/{ref}', companiesController::class.':createUpdate', 'CreateCompanies', FALSE);
        $this->route->delete('/companies/{ref}', companiesController::class.':delete', 'DeleteCompanies', FALSE);
    }

    protected function contactRoutes(){
        $this->route->get('/contactsParent', contactsController::class.':list', 'ViewContacts')->addToMenu("Contacts", "money-check");
        $this->route->get('/contacts', contactsController::class.':list', 'ViewContacts')->addToMenu("View Contacts", "", '/contactsParent');
        $this->route->get('/data/contacts/list', contactsController::class.':dataContactsList', 'ViewContacts', FALSE);
        $this->route->get('/data/contacts/filterForm', contactsController::class.':filterForm', 'ViewContacts', FALSE);

        $this->route->get('/contacts/create', contactsController::class.':create', 'CreateContacts')->addToMenu("Create A Contact", "", '/contactsParent');
        $this->route->get('/data/contacts/createForm', contactsController::class.':manageForm', 'CreateContacts', FALSE);

        $this->route->get('/contacts/{ref}/edit', contactsController::class.':update', 'UpdateContacts');
        $this->route->get('/contacts/{ref}/delete', contactsController::class.':deleteView', 'DeleteContacts');
        $this->route->get('/contacts/{ref}', contactsController::class.':view', 'ViewContacts');
        $this->route->get('/data/contacts/{ref}/updateForm', contactsController::class.':manageForm', 'UpdateContacts', FALSE);

        $this->route->post('/contacts', contactsController::class.':createUpdate', 'CreateContacts', FALSE);
        $this->route->post('/contacts/{ref}', contactsController::class.':createUpdate', 'CreateContacts', FALSE);
        $this->route->delete('/contacts/{ref}', contactsController::class.':delete', 'DeleteContacts', FALSE);

        $this->route->get('/contacts/export/mailList', contactsController::class.':exportMailList', 'CreateContacts', FALSE);
        $this->route->get('/contacts/export/contactList', contactsController::class.':exportContactList', 'CreateContacts', FALSE);
    }

    protected function vehicleTypesRoutes(){
        $this->route->get('/vehicles/types', typesController::class.':list', 'ViewTypes')->addToMenu("View Vehicle Types", "", '/vehiclesParent');
        $this->route->get('/data/vehicles/types/list', typesController::class.':dataTypesList', 'ViewTypes', FALSE);

        $this->route->get('/vehicles/types/create', typesController::class.':create', 'CreateTypes')->addToMenu("Create A Vehicle Type", "", '/vehiclesParent');
        $this->route->get('/data/vehicles/types/createForm', typesController::class.':manageForm', 'CreateTypes', FALSE);

        $this->route->get('/vehicles/types/{ref}', typesController::class.':view', 'ViewTypes');
        $this->route->get('/vehicles/types/{ref}/edit', typesController::class.':update', 'UpdateTypes');
        $this->route->get('/vehicles/types/{ref}/delete', typesController::class.':deleteView', 'DeleteTypes');
        $this->route->get('/data/vehicles/types/{ref}/updateForm', typesController::class.':manageForm', 'UpdateTypes', FALSE);

        $this->route->post('/vehicles/types', typesController::class.':createUpdate', 'CreateTypes', FALSE);
        $this->route->delete('/vehicles/types/{ref}', typesController::class.':delete', 'DeleteTypes', FALSE);
    }

    protected function vehicleRoutes(){
        $this->route->get('/vehiclesParent', vehiclesController::class.':list', 'ViewVehicles')->addToMenu("Contacts", "truck");
        $this->route->get('/vehicles', vehiclesController::class.':list', 'ViewVehicles')->addToMenu("View Contacts", "", '/vehiclesParent');
        $this->route->get('/data/vehicles/list', vehiclesController::class.':dataVehiclesList', 'ViewVehicles', FALSE);

        $this->route->get('/vehicles/create', vehiclesController::class.':create', 'CreateVehicles')->addToMenu("Create A Contact", "", '/vehiclesParent');
        $this->route->get('/data/vehicles/createForm', vehiclesController::class.':manageForm', 'CreateVehicles', FALSE);

        $this->route->get('/vehicles/{ref}/edit', vehiclesController::class.':update', 'UpdateVehicles');
        $this->route->get('/vehicles/{ref}/delete', vehiclesController::class.':deleteView', 'DeleteVehicles');
        $this->route->get('/vehicles/{ref}', vehiclesController::class.':view', 'ViewVehicles');
        $this->route->get('/data/vehicles/{ref}/updateForm', vehiclesController::class.':manageForm', 'UpdateVehicles', FALSE);

        $this->route->post('/vehicles', vehiclesController::class.':createUpdate', 'CreateVehicles', FALSE);
        $this->route->post('/vehicles/{ref}', vehiclesController::class.':createUpdate', 'CreateVehicles', FALSE);
        $this->route->delete('/vehicles/{ref}', vehiclesController::class.':delete', 'DeleteVehicles', FALSE);
    }

    protected function accountRoutes(){

        $this->route->get('/data/users/list', usersController::class.':dataUserList', 'ViewUsers', FALSE);
        $this->route->get('/data/users/filterForm', usersController::class.':filterForm', 'ViewUsers', FALSE);

        $this->route->get('/users/create', usersController::class.':create', 'CreateUsers')->addToMenu("Create A User", "", '/usersParent');
        $this->route->get('/data/users/createForm', usersController::class.':manageForm', 'CreateUsers', FALSE);

        $this->route->get('/users/{ref}/edit', usersController::class.':update', 'UpdateUsers');
        $this->route->get('/users/{ref}/delete', usersController::class.':deleteView', 'DeleteUsers');
        $this->route->get('/users/{ref}', usersController::class.':view', 'ViewUsers');
        $this->route->get('/data/users/{ref}/updateForm', usersController::class.':manageForm', 'UpdateUsers', FALSE);
        $this->route->get('/users', usersController::class.':list', 'CreateUsers', FALSE);

        $this->route->post('/users/{ref}', usersController::class.':createUpdate', 'UpdateUsers', FALSE);
        $this->route->post('/users', usersController::class.':createUpdate', 'CreateUsers', FALSE);
        $this->route->delete('/users/{ref}', usersController::class.':delete', 'DeleteUsers', FALSE);

        $this->route->get('/account', usersController::class.':account', 'ManageOwnAccount');
        $this->route->get('/data/users/{ref}/accountForm', usersController::class.':accountUpdate', 'ManageOwnAccount', FALSE);
        $this->route->post('/account/{ref}/update', usersController::class.':accountCreateUpdate', 'ManageOwnAccount');

    }

    protected function rolesRoutes(){
        $this->route->get('/roles', rolesController::class.':list', 'ViewRoles')->addToMenu("View Roles", "", '/usersParent');
        $this->route->get('/data/roles/list', rolesController::class.':dataRolesList', 'ViewRoles', FALSE);

        $this->route->get('/roles/create', rolesController::class.':create', 'CreateRoles')->addToMenu("Create A Role", "", '/usersParent');
        $this->route->get('/data/roles/createForm', rolesController::class.':manageForm', 'CreateRoles', FALSE);

        $this->route->get('/roles/{ref}/edit', rolesController::class.':update', 'UpdateRoles');
        $this->route->get('/roles/{ref}/delete', rolesController::class.':deleteView', 'DeleteRoles');
        $this->route->get('/roles/{ref}', rolesController::class.':view', 'ViewRoles');
        $this->route->get('/data/roles/{ref}/updateForm', rolesController::class.':manageForm', 'UpdateRoles', FALSE);

        $this->route->post('/roles', rolesController::class.':createUpdate', 'CreateRoles', FALSE);
        $this->route->post('/roles/{ref}', rolesController::class.':createUpdate', 'UpdateRoles', FALSE);
        $this->route->delete('/roles/{ref}', rolesController::class.':delete', 'DeleteRoles', FALSE);
    }

    protected function franchiseRoutes(){
        $this->route->get('/franchiseesParent', franchiseController::class.':list', 'ViewFranchises')->addToMenu("View Franchises", "project-diagram");
        $this->route->get('/franchisees', franchiseController::class.':list', 'ViewFranchises')->addToMenu("View Franchises", "", '/franchiseesParent');
        $this->route->get('/data/franchisees/list', franchiseController::class.':dataFranchiseList', 'ViewFranchises', FALSE);

        $this->route->get('/franchisees/create', franchiseController::class.':create', 'CreateFranchises')->addToMenu("Create A Franchise", "", '/franchiseesParent');
        $this->route->get('/data/franchisees/createForm', franchiseController::class.':manageForm', 'CreateFranchises', FALSE);

        $this->route->get('/franchisees/{ref}/edit', franchiseController::class.':update', 'UpdateFranchises');
        $this->route->get('/franchisees/{ref}/delete', franchiseController::class.':deleteView', 'DeleteFranchises');
        $this->route->get('/franchisees/{ref}', franchiseController::class.':view', 'ViewFranchises');
        $this->route->get('/data/franchisees/{ref}/updateForm', franchiseController::class.':manageForm', 'UpdateFranchises', FALSE);

        $this->route->post('/franchisees', franchiseController::class.':createUpdate', 'CreateFranchises', FALSE);
        $this->route->post('/franchisees/{ref}', franchiseController::class.':createUpdate', 'UpdateFranchises', FALSE);
        $this->route->delete('/franchisees/{ref}', franchiseController::class.':delete', 'DeleteFranchises', FALSE);
    }

    protected function documentRoutes(){
        $this->route->get('/documentsParent', documentsController::class.':list', 'ViewDocuments')->addToMenu("View Document", "file-pdf");
        $this->route->get('/documents', documentsController::class.':list', 'ViewDocuments')->addToMenu("View Document", "", '/documentsParent');
        $this->route->get('/data/documents/list', documentsController::class.':dataDocumentsList', 'ViewDocuments', FALSE);

        $this->route->get('/documents/create', documentsController::class.':create', 'CreateDocuments')->addToMenu("Create A Document", "", '/documentsParent');
        $this->route->get('/data/documents/createForm', documentsController::class.':manageForm', 'CreateDocuments', FALSE);
        $this->route->post('/data/documents/saveFile', documentsController::class.':saveFile', 'CreateDocuments', FALSE);

        $this->route->get('/documents/{ref}/edit', documentsController::class.':update', 'UpdateDocuments');
        $this->route->get('/documents/{ref}/delete', documentsController::class.':deleteView', 'DeleteDocuments');
        $this->route->get('/documents/{ref}', documentsController::class.':view', 'ViewDocuments');
        $this->route->get('/data/documents/{ref}/updateForm', documentsController::class.':manageForm', 'UpdateDocuments', FALSE);

        $this->route->post('/documents', documentsController::class.':createUpdate', 'CreateDocuments', FALSE);
        $this->route->post('/documents/{ref}', documentsController::class.':createUpdate', 'UpdateDocuments', FALSE);
        $this->route->delete('/documents/{ref}', documentsController::class.':delete', 'DeleteDocuments', FALSE);

        $this->route->get('/documents/{ref}/download', documentsController::class.':download', 'ViewDocuments');
    }

    protected function importRoutes(){
        $this->route->get('/imports', AmazonJobImportController::class.':importPage', 'ImportAmazon', FALSE);
        $this->route->post('/imports', AmazonJobImportController::class.':saveFile', 'ImportAmazon', FALSE);

        $this->route->get('/data/imports/importForm', AmazonJobImportController::class.':importForm', 'ImportAmazon', FALSE);
        $this->route->get('/data/imports', AmazonJobImportController::class.':dataImportListSimple', 'ImportAmazon', FALSE);

    }

    protected function defectRoutes(){
        $this->route->get('/defects', defectController::class.':defectView', 'viewDefects', FALSE);
        $this->route->post('/defects', defectController::class.':defectFormSave', 'createDefects', FALSE);

        $this->route->get('/data/defects/defectForm', defectController::class.':defectForm', 'createDefects', FALSE);
        $this->route->get('/data/defects', defectController::class.':defectList', 'viewDefects', FALSE);

    }
}