<?php

namespace apexl\hashing\drivers;

use apexl\hashing\interfaces\Hashing;

class Blowfish implements Hashing
{
    public static function generateRandomSalt(): string
    {
        return '$2y$07$'.strtr(self::generateRandomHash(), '+', '.');
    }

    public static function generateRandomHash(): string
    {
        return base64_encode(openssl_random_pseudo_bytes(64));
    }

    public static function hashString($string, $salt): ?string
    {
        return crypt((string) $string, (string) $salt);
    }
}
