<?php

namespace apexl\Io\modules\accessControl\callbacks;

use apexl\Io\modules\user\services\currentUser;

class accessControl {

    protected static $accessControlTypeNamespaces = [
        'app\accessControl\type\\',
        'apexl\Io\modules\accessControl\callbacks\accessControlTypes\\'
    ];

    /**
     * @param $query
     * @param $type
     * @param $table
     * @return mixed
     */
    public static function implement($query, $type, $table)
    {
        $query = self::implementJoins($query, $type, $table);
        $query = self::implementClauses($query, $type, $table);

        return $query;
    }

    /**
     * @param $query
     * @param $type
     * @param $table
     * @return mixed
     */
    public static function implementJoins($query, $type, $table)
    {
        return self::methodCall($query, $type, $table, 'addJoins');
    }

    /**
     * @param $query
     * @param $type
     * @param $table
     * @return mixed
     */
    public static function implementClauses($query, $type, $table)
    {
        return self::methodCall($query, $type, $table, 'addClauses');
    }

    /**
     * @param $query
     * @param $type
     * @param $table
     * @param $func
     * @return mixed
     */
    protected static function methodCall($query, $type, $table, $func)
    {
        $currentUser = currentUser::getCurrentUser(); // @ToDo uncomment God User code
        if (!is_object($currentUser) || empty($type) || $currentUser->isAllowed('AccessGlobalEntities')) return $query;

        foreach (self::$accessControlTypeNamespaces as $ns) {
            $accessControlTypeClassName = $ns . $type;
            if (class_exists($accessControlTypeClassName)) {
                return $accessControlTypeClassName::$func($query, $table, $currentUser);
            }
        }

        return $query;
    }

}