<?php
namespace apexl\Io\modules\accessControl;

use apexl\Io\includes\Hook;
use apexl\Io\includes\Module;
use apexl\Io\modules\accessControl\callbacks\accessControl;
use apexl\Io\modules\accessControl\controllers\adminDisplayController;
use apexl\Io\modules\accessControl\controllers\formDisplayController;
use apexl\Io\modules\menu\services\Menu;

class accessControlModule extends Module {

    public function __construct()
    {
        parent::__construct();
        //$this->registerHooks();
    }

    public function routes(){

        //Configuration Route
        $this->rootRoute('GET', 'accessControl.configuration.ac.update', 'admin/configuration/access-control', adminDisplayController::class.':updateAccessControl');
        $this->route::addRouteArg('accessControl.configuration.ac.update', 'permission', 'ManageConfiguration');

        //Form Routes
        $this->rootRoute('GET', 'accessControl.form.configuration.ac.update', 'admin/forms/configuration/access-control', formDisplayController::class.':accessControlForm');
        $this->route::addRouteArg('accessControl.form.configuration.ac.update', 'permission', 'ManageConfiguration');

        //form post routes
        $this->rootRoute('PUT', 'accessControl.put.configuration.ac.update', 'configuration/access-control', adminDisplayController::class.':updateAccessControlSave');
        $this->route::addRouteArg('accessControl.put.configuration.ac.update', 'permission', 'ManageConfiguration');
    }

    public function registerCallbacks(){
        Hook::registerCallback('accessControl', accessControl::class.':implement');
        Hook::registerCallback('accessControlJoins', accessControl::class.':implementJoins');
        Hook::registerCallback('accessControlClauses', accessControl::class.':implementClauses');
    }

    public function registerMenuItems(Menu $menu)
    {
        $menu::addToMenu('accessControl.configuration.ac.update', [
            'title' => 'Access Control',
            'weight' => - 10,
            'icon' => 'exclamation-triangle',
            'parent' => 'adminDisplay.configuration'
        ], 'administration');
    }
}