<?php

namespace apexl\Io\modules\accessControl\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\System;
use apexl\Io\modules\display\services\Render;
use apexl\Io\modules\user\services\currentUser;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class adminDisplayController extends Controller
{
    public function __construct(Render $render, currentUser $currentUser)
    {
        parent::__construct();
        $this->currentUser = $currentUser::getCurrentUser();
        $this->render = $render;
    }

    public function updateAccessControl(Request $request, Response $response){
        $this->render::setMetaTitle("Administration | Update Access Control List");
        $this->render::setPageTitle("Update Access Control List");

        //Get list of all Access Control Classes.
        $acClasses = $this->getAllAccessControlTypes();

        //Get list of all Entities.

        return System::asJson($response);
    }

    public function updateAccessControlSave(Request $request,Response $response){
        $body = $request->getParsedBody();

        System::writeConfig('app', ['accessControl' => []]);

        $this->output::addMessage('core.file.upload', 'success', '');
        $this->output::addResponse($request);
        return System::asJson($response);
    }

    protected function getAllAccessControlTypes(){
        $classes = get_declared_classes();
        $accessControlTypes = array();
        foreach($classes as $acClass) {
            $reflect = new \ReflectionClass($acClass);
            if($reflect->implementsInterface('accessControlTypeInterface')) {
                $accessControlTypes[] = $acClass;
            }
        }
        return $accessControlTypes;
    }
}