<?php
namespace apexl\Io\middleware\permission;

use apexl\Io\modules\component\services\Component;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Server\MiddlewareInterface;
use Psr\Http\Server\RequestHandlerInterface as RequestHandler;

class commonComponentsController implements MiddlewareInterface
{
    protected $components;

    public function __construct(Component $component)
    {
        $this->components = $component;
    }

    public function process(Request $request, RequestHandler $handler): Response
    {
        $this->registerCommonComponents();
        return $handler->handle($request);
    }

    protected function registerCommonComponents(){
        $this->components->createComponent('Content');
        $this->components->createComponent('Form');
        $this->components->createComponent('ThePageContent');
    }
}