<?php

namespace apexl\Io\modules\address;

use apexl\Io\includes\Module;
use apexl\Io\includes\System;
use apexl\Io\modules\component\services\Component;

/**
 * Base module file, provides required methods to register things like routes and middleware.
 * Class installModule
 * @package apexl\Io\modules\install
 */
class addressModule extends Module {

    public function __construct()
    {
        parent::__construct();
    }

    public function routes(){
        $this->route->get('address/create', addressController::class.':create', 'AllowAll');
        $this->route->get('address/{ref}/update', addressController::class.':update', 'AllowAll');
        $this->route->get('address/view', addressController::class.':view', 'AllowAll');
        $this->route->get('address/delete', addressController::class.':delete', 'AllowAll');
    }

    public function schema(){
        return System::loadSchema(__DIR__.'/schema/schema.json');
    }

    public function install(){
        //we assume that the initial install route for this module has added the db config before we get to this point.
    }
}