<?php

namespace apexl\Io\modules\address\controllers;

use apexl\Io\includes\System;
use apexl\Io\services\Component;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class addressController{

    protected $addressGroup;
    protected $address;
    public function __construct(Address $address)
    {
        $this->address = $address;
    }

    public function create(Request $request, Response $response, $args){
        $address = new addressEntity();
        $body = $request->getParsedBody();

        $address->entityType = $body->entityType;
        $address->addressLine1 = $body->addressLine1;
        $address->addressLine2 = $body->addressLine2;
        $address->postcode = $body->postcode;
        $address->city = $body->city;

        return System::asJson($response, $address->getData());
    }

    public function update(Request $request, Response $response, $args){
        $address = new addressEntity();

        $address->load($args['ref']);

        if(!isset($address->ref)){
            return System::asJson($response, ['message' => '404 not found, job id '.$args['ref'].' is missing or malformed.'], 404);
        }

        $address->entityType = $body->entityType;
        $address->addressLine1 = $body->addressLine1;
        $address->addressLine2 = $body->addressLine2;
        $address->postcode = $body->postcode;
        $address->city = $body->city;

        return System::asJson($response, $address->getData());
    }

    public function view(Request $request, Response $response, $args){
        $params = $request->getQueryParams();
        $addresses = (new addressEntity())->loadMultiple([], [], $params['limit'], $params['offset']);
        $totalResults = (new addressEntity())->totalEntities();
        $totalPages = ceil (($totalResults/$params['limit']));
        $data = [];
        foreach($addresses as $address){
            $data[] = $address->getData();
        }
        $tableHeader = isset($data[0]) ? array_keys((array)$data[0]) : [];
        return System::asJson($response, ['rows' => $data, 'totalData' => $totalResults, 'totalPages' => $totalPages, 'tableHeader' => $tableHeader]);
    }

    public function delete(Request $request, Response $response, $args){
        (new addressEntity())->delete($args['ref']);
        return System::asJson($response, ['success' => 'true', 'redirectTo' => '/address']);
    }
}