<?php

namespace apexl\Io\modules\address\entities\operators;

use apexl\Io\modules\component\entities\propertyEntity;
use apexl\Io\operators\entityDatabaseOperator;

class propertyOperator extends entityDatabaseOperator
{
    public function __construct($table, $primaryKey = 'id')
    {
        parent::__construct($table, $primaryKey);
    }

    public function getByCid($cid){
        $props = $this->vault->select($this->dbTable)
            ->fields('id')
            ->where('cid', $cid)
            ->execute()->fetchAll();

        //return a loaded array
        $loadedProps = [];
        if(!empty($loadedProps)) {
            foreach ($props as $prop) {
                $loadedProps[$prop->id] = (new propertyEntity())->load($prop->id);
            }
        }
        return $loadedProps;
    }
}