<?php
namespace apexl\Io\modules\adminDisplay\components;

use apexl\Io\modules\component\entities\componentEntity;
use apexl\Io\modules\display\components\ContentTitle;
use apexl\Io\modules\display\components\LinkTile;
use apexl\Io\modules\display\components\RowWrapper;

class menuTile extends componentEntity {

    protected $componentWrapper;

    public function __construct($title = null)
    {
        parent::__construct();
        $this->setName("RowWrapper");
        $this->addClass("menu-tile-wrapper");
        $this->setColWidth('md', 6);
        $this->setColWidth('sm', 12);

        $this->componentWrapper = (new RowWrapper())->resetClasses()->resetColumns()->addClass('content-wrapper');
        $this->addComponent($this->componentWrapper);
        if($title){
            $this->addTitle($title);
        }
    }

    public function addTitle($title){
        $this->componentWrapper->addComponent((new ContentTitle())->addTitle($title)->addClass("tileTitle")->addHeader(5));
        return $this;
    }

    public function addButton($route, $name, $icon = ''){
        $this->componentWrapper->addComponent((new LinkTile())->addRoute($route)->addText($name)->addIcon($icon));
        return $this;
    }
}