<?php

namespace apexl\Io\modules\adminDisplay\controllers;

use apexl\Config\Singleton;
use apexl\Io\includes\Controller;
use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\modules\display\components\FormComponent;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\inputField;
use apexl\Io\modules\formbuilder\includes\textareaField;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class formDisplayController extends Controller
{
    public function __construct()
    {
        parent::__construct();
    }

    public function allowedDomainsForm(Request $request, Response $response){
        $form = new formEntity();
        $form->setId('allowedDomainsForm');
        $form->setMethod('put');
        $form->setActionUrl(Routes::getRoutePattern("admin.configuration.ad.update"));

        $form->addField((new textareaField("allowedDomains"))->setLabel("Allowed Domains")->setValue(implode(',', $this->config->app->allowedDomains)));

        return System::asJson($response, $form->getBuiltFormArray());
    }
}