<?php

namespace apexl\Io\modules\adminDisplay\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\modules\display\components\FormComponent;
use apexl\Io\modules\display\services\Render;
use apexl\Io\modules\user\services\currentUser;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class configurationDisplayController extends Controller
{
    protected $currentUser;
    protected $render;

    public function __construct(Render $render, currentUser $currentUser)
    {
        parent::__construct();
        $this->currentUser = $currentUser::getCurrentUser();
        $this->render = $render;
    }

    public function updateAllowedDomains(Request $request, Response $response): Response
    {
        $this->render::setMetaTitle('Administration | Update Allowed Domains List');
        $this->render::setPageTitle('Update Allowed Domains List');
        $form = (
        new FormComponent())
            ->setID('accessControlUpdate')
            ->src(Routes::getRoutePattern('adminDisplay.form.configuration.ad.update'))
            ->title('A Comma seperated list of domains allowed to make requests to this API.');
        $this->output::addResponse($request, $this->render::build($form));

        return System::asJson($response);
    }
}
