<?php

declare(strict_types=1);

namespace apexl\Io\modules\admin;

use apexl\Io\enums\HttpMethod;
use apexl\Io\modules\admin\controllers\configurationController;
use apexl\Io\modules\user\classes\userManagedApiModule;
use apexl\Io\modules\user\interfaces\registersPermissions;
use apexl\Io\modules\user\services\Permissions;

class adminModule extends userManagedApiModule implements RegistersPermissions
{
    public function routes(): void
    {
        // Add Configuration Routes
        $this->addProtectedAdminActionRoute(
            HttpMethod::PUT,
            'admin.configuration.ad.update',
            'configuration/allowed-domains',
            configurationController::class.':updateAllowedDomains',
            'ManageConfiguration'
        );
        $this->addProtectedAdminActionRoute(
            HttpMethod::PUT,
            'admin.configuration.installation.update',
            'configuration/installation',
            configurationController::class.':updateInstallation',
            'ManageConfiguration'
        );
        $this->addProtectedAdminActionRoute(
            HttpMethod::PUT,
            'admin.configuration.sessions.update',
            'configuration/sessions',
            configurationController::class.':updateSessions',
            'ManageConfiguration'
        );
        $this->addProtectedAdminActionRoute(
            HttpMethod::PUT,
            'admin.configuration.email.update',
            'configuration/email',
            configurationController::class.':updateEmail',
            'ManageConfiguration'
        );
        $this->addProtectedAdminActionRoute(
            HttpMethod::PUT,
            'admin.configuration.site.update',
            'configuration/site',
            configurationController::class.':updateSite',
            'ManageConfiguration'
        );
        $this->addProtectedAdminActionRoute(
            HttpMethod::PUT,
            'admin.configuration.databases.update',
            'configuration/databases',
            configurationController::class.':updateDatabases',
            'ManageConfiguration'
        );
        $this->addProtectedAdminActionRoute(
            HttpMethod::PUT,
            'admin.configuration.metadata.update',
            'configuration/meta-data',
            configurationController::class.':updateMetadata',
            'ManageConfiguration'
        );

        // Add System Routes
    }

    public function permissions(Permissions $permissions): void
    {
        $permissions->registerPermission('administer', 'Access Administration', 'Admin');
        $permissions->registerPermission('ManageConfiguration', 'Manage Configuration', 'Admin');
    }
}
