<?php

declare(strict_types=1);

namespace apexl\Io\modules\adminDisplay;

use apexl\Io\enums\HttpMethod;
use apexl\Io\modules\adminDisplay\controllers\adminDisplayController;
use apexl\Io\modules\adminDisplay\controllers\configurationDisplayController;
use apexl\Io\modules\adminDisplay\controllers\formDisplayController;
use apexl\Io\modules\menu\interfaces\registersMenuItems;
use apexl\Io\modules\menu\services\Menu;
use apexl\Io\modules\user\classes\userManagedDisplayModule;

class adminDisplayModule extends userManagedDisplayModule implements registersMenuItems
{
    public function __construct()
    {
        parent::__construct();
    }

    public function routes(): void
    {
        // Main Admin dashboard
        $this->addProtectedAdminRootRoute(
            HttpMethod::GET,
            'adminDisplay.dashboard',
            'dashboard',
            adminDisplayController::class.':dashboard',
            'administer'
        );

        // Add Configuration Routes
        $this->addProtectedAdminRootRoute(
            HttpMethod::GET,
            'adminDisplay.configuration.ad.update',
            'configuration/allowed-domains',
            configurationDisplayController::class.':updateAllowedDomains',
            'ManageConfiguration'
        );
        $this->addProtectedAdminRootRoute(
            HttpMethod::GET,
            'adminDisplay.configuration.installation.update',
            'configuration/installation',
            configurationDisplayController::class.':updateInstallation',
            'ManageConfiguration'
        );
        $this->addProtectedAdminRootRoute(
            HttpMethod::GET,
            'adminDisplay.configuration.sessions.update',
            'configuration/sessions',
            configurationDisplayController::class.':updateSessions',
            'ManageConfiguration'
        );
        $this->addProtectedAdminRootRoute(
            HttpMethod::GET,
            'adminDisplay.configuration.email.update',
            'configuration/email',
            configurationDisplayController::class.':updateEmail',
            'ManageConfiguration'
        );
        $this->addProtectedAdminRootRoute(
            HttpMethod::GET,
            'adminDisplay.configuration.site.update',
            'configuration/site',
            configurationDisplayController::class.':updateSite',
            'ManageConfiguration'
        );
        $this->addProtectedAdminRootRoute(
            HttpMethod::GET,
            'adminDisplay.configuration.databases.update',
            'configuration/databases',
            configurationDisplayController::class.':updateDatabases',
            'ManageConfiguration'
        );
        $this->addProtectedAdminRootRoute(
            HttpMethod::GET,
            'adminDisplay.configuration.metadata.update',
            'configuration/meta-data',
            configurationDisplayController::class.':updateMetadata',
            'ManageConfiguration'
        );

        // Add System Routes
        $this->addProtectedAdminRootRoute(
            HttpMethod::GET,
            'adminDisplay.system.extentions',
            'system/extentions',
            configurationDisplayController::class.':updateAccessControl',
            'ManageConfiguration'
        );
        $this->addProtectedAdminRootRoute(
            HttpMethod::GET,
            'adminDisplay.system.maintinance',
            'system/mainbtinance-mode',
            configurationDisplayController::class.':updateAllowedDomains',
            'ManageConfiguration'
        );
        $this->addProtectedAdminRootRoute(
            HttpMethod::GET,
            'adminDisplay.system.force-logout',
            'system/force-logout',
            configurationDisplayController::class.':updateInstallation',
            'ManageConfiguration'
        );
        $this->addProtectedAdminRootRoute(
            HttpMethod::GET,
            'adminDisplay.system.api-routes',
            'system/api-routes',
            configurationDisplayController::class.':updateSessions',
            'ManageConfiguration'
        );

        $this->addProtectedFormRoute(
            'adminDisplay.form.configuration.ad.update',
            'configuration/allowed-domains',
            formDisplayController::class.':allowedDomainsForm',
            'ManageConfiguration'
        );
    }

    public function menuItems(Menu $menu): void
    {
        // Navigation Menu
        $menu::addToMenu('adminDisplay.dashboard', [
            'title' => 'Administration Dashboard',
            'icon' => 'shield-alt',
            'weight' => 100,
        ]);

        // Configuration Links
        $menu::addToMenu('adminDisplay.configuration', [
            'title' => 'Configuration',
            'icon' => 'cogs',
            'weight' => -12,
        ], 'administration');

        $menu::addToMenu('adminDisplay.configuration.ad.update', [
            'title' => 'Allowed Domains',
            'weight' => -9,
            'icon' => 'globe',
            'parent' => 'adminDisplay.configuration',
        ], 'administration');

        $menu::addToMenu('adminDisplay.configuration.installation.update', [
            'title' => 'Installation',
            'weight' => -8,
            'icon' => 'box-up',
            'parent' => 'adminDisplay.configuration',
        ], 'administration');

        $menu::addToMenu('adminDisplay.configuration.sessions.update', [
            'title' => 'Sessions',
            'weight' => -7,
            'icon' => 'address-card',
            'parent' => 'adminDisplay.configuration',
        ], 'administration');

        $menu::addToMenu('adminDisplay.configuration.email.update', [
            'title' => 'Email',
            'weight' => -6,
            'icon' => 'envelope',
            'parent' => 'adminDisplay.configuration',
        ], 'administration');

        $menu::addToMenu('adminDisplay.configuration.site.update', [
            'title' => 'Site',
            'weight' => -5,
            'icon' => 'browser',
            'parent' => 'adminDisplay.configuration',
        ], 'administration');

        $menu::addToMenu('adminDisplay.configuration.databases.update', [
            'title' => 'Databases',
            'weight' => -4,
            'icon' => 'database',
            'parent' => 'adminDisplay.configuration',
        ], 'administration');

        $menu::addToMenu('adminDisplay.configuration.metadata.update', [
            'title' => 'Metadata',
            'weight' => -3,
            'icon' => 'info-square',
            'parent' => 'adminDisplay.configuration',
        ], 'administration');

        // System Links
        $menu::addToMenu('adminDisplay.system', [
            'title' => 'System',
            'icon' => 'cogs',
            'weight' => -11,
        ], 'administration');

        $menu::addToMenu('adminDisplay.system.extentions', [
            'title' => 'Extentions',
            'weight' => -10,
            'icon' => 'boxes-alt',
            'parent' => 'adminDisplay.system',
        ], 'administration');

        $menu::addToMenu('adminDisplay.system.maintinance', [
            'title' => 'Access Control',
            'weight' => -9,
            'icon' => 'tools',
            'parent' => 'adminDisplay.system',
        ], 'administration');

        $menu::addToMenu('adminDisplay.system.force-logout', [
            'title' => 'Force Logout',
            'weight' => -8,
            'icon' => 'sign-out',
            'parent' => 'adminDisplay.system',
        ], 'administration');

        $menu::addToMenu('adminDisplay.system.api-routes', [
            'title' => 'API Routes',
            'weight' => -7,
            'icon' => 'sitemap',
            'parent' => 'adminDisplay.system',
        ], 'administration');

        // Reporting Links
        $menu::addToMenu('adminDisplay.reporting', [
            'title' => 'Reporting',
            'icon' => 'bug',
            'weight' => -12,
        ], 'administration');
    }
}
