<?php

namespace apexl\Io\modules\adminDisplay\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\System;
use apexl\Io\modules\adminDisplay\components\menuTile;
use apexl\Io\modules\display\components\RowWrapper;
use apexl\Io\modules\display\services\Render;
use apexl\Io\modules\menu\services\Menu;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\services\currentUser;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class adminDisplayController extends Controller
{
    public ?userEntity $currentUser;
    public Render $render;
    public Menu $menu;

    public function __construct(Render $render, currentUser $currentUser, Menu $menu)
    {
        parent::__construct();
        $this->currentUser = $currentUser::getCurrentUser();
        $this->render = $render;
        $this->menu = $menu;
    }

    public function dashboard(Request $request, Response $response): Response
    {
        $this->render::setPageTitle('Administration Dashboard');

        $rowWrapper = new RowWrapper();
        $rowWrapper->addClass('flex-gap');
        // Get all administration links, loop over them and split them by parent item.
        $items = $this->menu::getMenu('administration');
        $menuItems = $items->getAllItemsAsMenu($this->currentUser);
        foreach ($menuItems as $item) {
            if ($item->links) {
                $tile = new menuTile($item->title);
                foreach ($item->links as $routeInfo) {
                    $tile->addButton($routeInfo->href, $routeInfo->title, $routeInfo->icon);
                }
                $rowWrapper->addComponent($tile);
            }
        }

        $this->output::addResponse($request, $this->render::build([$rowWrapper]));

        return System::asJson($response);
    }
}
