<?php

declare(strict_types=1);

namespace apexl\Io\modules\admin;

use apexl\Io\enums\HttpMethod;
use apexl\Io\modules\admin\controllers\configurationController;
use apexl\Io\modules\admin\enums\permissions\Admin;
use apexl\Io\modules\user\classes\userManagedApiModule;
use apexl\Io\modules\user\interfaces\registersPermissions;
use apexl\Io\modules\user\services\Permissions;

class adminModule extends userManagedApiModule implements RegistersPermissions
{
    public function routes(): void
    {
        // Add Configuration Routes
        $this->addProtectedAdminActionRoute(
            HttpMethod::PUT,
            'admin.configuration.ad.update',
            'configuration/allowed-domains',
            configurationController::class.':updateAllowedDomains',
            Admin::CONFIGURE
        );
        $this->addProtectedAdminActionRoute(
            HttpMethod::PUT,
            'admin.configuration.installation.update',
            'configuration/installation',
            configurationController::class.':updateInstallation',
            Admin::CONFIGURE
        );
        $this->addProtectedAdminActionRoute(
            HttpMethod::PUT,
            'admin.configuration.sessions.update',
            'configuration/sessions',
            configurationController::class.':updateSessions',
            Admin::CONFIGURE
        );
        $this->addProtectedAdminActionRoute(
            HttpMethod::PUT,
            'admin.configuration.email.update',
            'configuration/email',
            configurationController::class.':updateEmail',
            Admin::CONFIGURE
        );
        $this->addProtectedAdminActionRoute(
            HttpMethod::PUT,
            'admin.configuration.site.update',
            'configuration/site',
            configurationController::class.':updateSite',
            Admin::CONFIGURE
        );
        $this->addProtectedAdminActionRoute(
            HttpMethod::PUT,
            'admin.configuration.databases.update',
            'configuration/databases',
            configurationController::class.':updateDatabases',
            Admin::CONFIGURE
        );
        $this->addProtectedAdminActionRoute(
            HttpMethod::PUT,
            'admin.configuration.metadata.update',
            'configuration/meta-data',
            configurationController::class.':updateMetadata',
            Admin::CONFIGURE
        );

        // Add System Routes
    }

    public function permissions(Permissions $permissions): void
    {
        $permissions->registerPermission(Admin::ADMINISTER, 'Access Administration', 'Admin');
        $permissions->registerPermission(Admin::CONFIGURE, 'Manage Configuration', 'Admin');
    }
}
