<?php

namespace apexl\Io\modules\admin\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\System;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class configurationController extends Controller
{
    public function updateAllowedDomains(Request $request, Response $response): Response
    {
        System::writeConfig('app', ['allowedDomains' => []]);

        $this->output::addMessage('core.file.upload', 'success', '');
        $this->output::addResponse($request);

        return System::asJson($response);
    }

    public function updateInstallation(Request $request, Response $response): Response
    {
        System::writeConfig('app', ['install' => []]);

        $this->output::addMessage('core.file.upload', 'success', '');
        $this->output::addResponse($request);

        return System::asJson($response);
    }

    public function updateSessions(Request $request, Response $response): Response
    {
        System::writeConfig('app', ['sessionTimeout' => '', 'permissions' => []]);

        $this->output::addMessage('core.file.upload', 'success', '');
        $this->output::addResponse($request);

        return System::asJson($response);
    }

    public function updateEmail(Request $request, Response $response): Response
    {
        System::writeConfig('app', ['email' => ['smtp' => []]]);

        $this->output::addMessage('core.file.upload', 'success', '');
        $this->output::addResponse($request);

        return System::asJson($response);
    }

    public function updateSite(Request $request, Response $response): Response
    {
        System::writeConfig('app', ['site' => []]);

        $this->output::addMessage('core.file.upload', 'success', '');
        $this->output::addResponse($request);

        return System::asJson($response);
    }

    public function updateDatabases(Request $request, Response $response): Response
    {
        System::writeConfig('vault', ['databases' => [$key => $config]]);

        $this->output::addMessage('core.file.upload', 'success', '');
        $this->output::addResponse($request);

        return System::asJson($response);
    }

    public function updateMetadata(Request $request, Response $response): Response
    {
        System::writeConfig('app', ['defaultMetaTitle' => '']);

        $this->output::addMessage('core.file.upload', 'success', '');
        $this->output::addResponse($request);

        return System::asJson($response);
    }
}
