<?php

declare(strict_types=1);

namespace apexl\Io\modules\adminDisplay;

use apexl\Io\enums\HttpMethod;
use apexl\Io\includes\RouteManager;
use apexl\Io\modules\admin\enums\permissions\Admin;
use apexl\Io\modules\adminDisplay\controllers\AdminDisplayController;
use apexl\Io\modules\adminDisplay\controllers\FormDisplayController;
use apexl\Io\modules\adminDisplay\controllers\UpdateAllowedDomainsController;
use apexl\Io\modules\menu\interfaces\ProvidesMenuItemsInterface;
use apexl\Io\modules\menu\services\MenuManager;
use apexl\Io\modules\system\interfaces\ProvidesRoutesInterface;
use apexl\Io\modules\user\classes\userManagedDisplayModule;
use apexl\Io\services\InstallChecker;

class adminDisplayModule extends userManagedDisplayModule implements ProvidesMenuItemsInterface, ProvidesRoutesInterface
{
    public function __construct(InstallChecker $installChecker)
    {
        parent::__construct($installChecker);
    }

    public function routes(RouteManager $routeManager): void
    {
        // Main Admin dashboard
        $this->addProtectedAdminRootRoute(
            $routeManager,
            HttpMethod::GET,
            'adminDisplay.dashboard',
            'dashboard',
            AdminDisplayController::class,
            Admin::ADMINISTER
        );

        $this->addProtectedAdminRootRoute(
            $routeManager,
            HttpMethod::GET,
            'adminDisplay.system.maintenance',
            'system/maintenance-mode',
            UpdateAllowedDomainsController::class,
            Admin::CONFIGURE,
        );

        $this->addProtectedFormRoute(
            $routeManager,
            'adminDisplay.form.configuration.ad.update',
            'configuration/allowed-domains',
            FormDisplayController::class,
            Admin::CONFIGURE,
        );
    }

    public function menuItems(MenuManager $menuManager): void
    {
        // Navigation Menu
        $menuManager->addToMenu('adminDisplay.dashboard', [
            'title' => 'Administration Dashboard',
            'icon' => 'shield-alt',
            'weight' => 100,
        ]);

        // Configuration Links
        $menuManager->addToMenu('adminDisplay.configuration', [
            'title' => 'Configuration',
            'icon' => 'cogs',
            'weight' => -12,
        ], 'administration');

        $menuManager->addToMenu('adminDisplay.configuration.ad.update', [
            'title' => 'Allowed Domains',
            'weight' => -9,
            'icon' => 'globe',
            'parent' => 'adminDisplay.configuration',
        ], 'administration');

        $menuManager->addToMenu('adminDisplay.configuration.installation.update', [
            'title' => 'Installation',
            'weight' => -8,
            'icon' => 'box-up',
            'parent' => 'adminDisplay.configuration',
        ], 'administration');

        $menuManager->addToMenu('adminDisplay.configuration.sessions.update', [
            'title' => 'Sessions',
            'weight' => -7,
            'icon' => 'address-card',
            'parent' => 'adminDisplay.configuration',
        ], 'administration');

        $menuManager->addToMenu('adminDisplay.configuration.email.update', [
            'title' => 'Email',
            'weight' => -6,
            'icon' => 'envelope',
            'parent' => 'adminDisplay.configuration',
        ], 'administration');

        $menuManager->addToMenu('adminDisplay.configuration.site.update', [
            'title' => 'Site',
            'weight' => -5,
            'icon' => 'browser',
            'parent' => 'adminDisplay.configuration',
        ], 'administration');

        $menuManager->addToMenu('adminDisplay.configuration.databases.update', [
            'title' => 'Databases',
            'weight' => -4,
            'icon' => 'database',
            'parent' => 'adminDisplay.configuration',
        ], 'administration');

        $menuManager->addToMenu('adminDisplay.configuration.metadata.update', [
            'title' => 'Metadata',
            'weight' => -3,
            'icon' => 'info-square',
            'parent' => 'adminDisplay.configuration',
        ], 'administration');

        // System Links
        $menuManager->addToMenu('adminDisplay.system', [
            'title' => 'System',
            'icon' => 'cogs',
            'weight' => -11,
        ], 'administration');

        $menuManager->addToMenu('adminDisplay.system.extentions', [
            'title' => 'Extentions',
            'weight' => -10,
            'icon' => 'boxes-alt',
            'parent' => 'adminDisplay.system',
        ], 'administration');

        $menuManager->addToMenu('adminDisplay.system.maintinance', [
            'title' => 'Access Control',
            'weight' => -9,
            'icon' => 'tools',
            'parent' => 'adminDisplay.system',
        ], 'administration');

        $menuManager->addToMenu('adminDisplay.system.force-logout', [
            'title' => 'Force Logout',
            'weight' => -8,
            'icon' => 'sign-out',
            'parent' => 'adminDisplay.system',
        ], 'administration');

        $menuManager->addToMenu('adminDisplay.system.api-routes', [
            'title' => 'API Routes',
            'weight' => -7,
            'icon' => 'sitemap',
            'parent' => 'adminDisplay.system',
        ], 'administration');

        // Reporting Links
        $menuManager->addToMenu('adminDisplay.reporting', [
            'title' => 'Reporting',
            'icon' => 'bug',
            'weight' => -12,
        ], 'administration');
    }
}
