<?php

namespace apexl\Io\modules\adminDisplay\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\RouteManager;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\textareaField;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

final readonly class FormDisplayController extends Controller
{
    public function __invoke(RouteManager $routeManager, ServerRequestInterface $request, ResponseInterface $response): ResponseInterface
    {
        $form = new formEntity();
        $form->setMethod('put');
        $form->setActionUrl($routeManager->getRoutePattern('admin.configuration.ad.update'));

        $form->addField(
            new textareaField('allowedDomains')->setLabel('Allowed Domains')->setValue(
                implode(',', config('app.allowedDomains'))
            )
        );

        return $this->json($response, $form->getBuiltFormArray());
    }
}
