<?php

namespace apexl\Io\modules\adminDisplay\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\RouteManager;
use apexl\Io\modules\display\components\FormComponent;
use apexl\Io\modules\display\services\Render;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

final readonly class UpdateAllowedDomainsController extends Controller
{
    public function __invoke(Render $render, RouteManager $routeManager, ServerRequestInterface $request, ResponseInterface $response): ResponseInterface
    {
        $render->setMetaTitle('Administration | Update Allowed Domains List');
        $render->setPageTitle('Update Allowed Domains List');
        $form = new FormComponent()
            ->src($routeManager->getRoutePattern('adminDisplay.form.configuration.ad.update'))
            ->title('A Comma seperated list of domains allowed to make requests to this API.');
        $this->output->addResponse($request, $render->build($form));

        return $this->json($response);
    }
}
