<?php

declare(strict_types=1);

namespace apexl\Io\modules\admin;

use apexl\Io\modules\admin\enums\permissions\Admin;
use apexl\Io\modules\user\classes\userManagedApiModule;
use apexl\Io\modules\user\interfaces\ProvidesPermissionsInterface;
use apexl\Io\modules\user\services\Permissions;

class adminModule extends userManagedApiModule implements ProvidesPermissionsInterface
{
    public function permissions(Permissions $permissions): void
    {
        $permissions->registerPermission(Admin::ADMINISTER, 'Access Administration', 'Admin');
        $permissions->registerPermission(Admin::CONFIGURE, 'Manage Configuration', 'Admin');
    }
}
