<?php

namespace apexl\Io\modules\adminDisplay\components;

use apexl\Io\modules\component\Collections\ComponentCollection;
use apexl\Io\modules\component\Collections\ComponentPropertyCollection;
use apexl\Io\modules\component\entities\Component;
use apexl\Io\modules\component\Factories\ComponentPropertyFactory;
use apexl\Io\modules\component\Factories\GenericComponentFactory;
use apexl\Io\modules\display\components\ContentTitle;
use apexl\Io\modules\display\components\LinkTile;
use apexl\Io\modules\display\components\RowWrapper;
use Arrayy\Type\StringCollection;

readonly class menuTile extends Component
{
  protected RowWrapper $componentWrapper;

  public function __construct(
      private GenericComponentFactory $componentFactory,
      ComponentPropertyFactory $propertyFactory,
      ComponentPropertyCollection $props,
      ComponentCollection $components,
      StringCollection $classes,
      ?string $componentName = null,
      ?string $componentId = null
  ) {
    parent::__construct(
        $propertyFactory,
        $props,
        $components,
        $classes,
        $componentName,
        $componentId
    );

    $this->componentWrapper = $this->componentFactory->make(RowWrapper::class)
        ->resetClasses()
        ->addClass('content-wrapper');
  }

  public function init(?string $title = null): void
  {
    $this->addClass('menu-tile-wrapper col-md-6 col-sm-6');

    $this->addComponent($this->componentWrapper);
    if ($title) {
      $this->addTitle($title);
    }
  }

  public function addTitle($title): static
  {
    $titleComponent = $this->componentFactory->make(ContentTitle::class)
        ->addTitle($title)->
        addClass('tileTitle')
        ->addHeader(5);

    $this->componentWrapper->addComponent($titleComponent);

    return $this;
  }

  public function addButton($route, $name, $icon = ''): static
  {
    $linkComponent = $this->componentFactory
        ->make(LinkTile::class)
        ->addRoute($route)
        ->addText($name)
        ->addIcon($icon);

    $this->componentWrapper->addComponent($linkComponent);

    return $this;
  }
}
