<?php

namespace apexl\Io\modules\basicApi;

use apexl\Io\includes\Controller;
use apexl\Io\includes\moduleStore;
use apexl\Io\modules\user\classes\userManagedApiModule;
use apexl\Io\modules\user\services\Permissions;

/**
 * Base module file, provides required methods to register things like routes and middleware.
 * Class installModule
 * @package apexl\Io\modules\install
 */
class basicApiModule extends userManagedApiModule
{
    protected $moduleStore;

    public function __construct(...$args)
    {
        $this->moduleStore = moduleStore::getInstance();
        parent::__construct();
        foreach ($args as $arg) {
            if (is_subclass_of($arg, '\apexl\Io\includes\Entity')) {
                $this->moduleStore::addEntityToStore($this->getName(), $arg);
            }
        }
    }

    public function routes()
    {
        if ($entities = $this->moduleStore::getModuleEntities($this->getName())) {
            foreach ($entities as $entity) {
                $this->addProtectedEntityRoutes($entity, [
                    'get' => [Controller::class.':get', 'View'.$entity->getEntityName()],
                    'put' => [Controller::class.':put', 'Update'.$entity->getEntityName()],
                    'post' => [Controller::class.':post', 'Create'.$entity->getEntityName()],
                    'delete' => [Controller::class.':delete', 'Delete'.$entity->getEntityName()],
                ]);
            }
        }
    }

    public function registerPermissions(Permissions $permissions)
    {
        if ($entities = $this->moduleStore::getModuleEntities($this->getName())) {
            foreach ($entities as $entity) {
                $permissions->registerPermission('View' . $entity->getEntityName(), 'View '.ucfirst($entity->getNiceName()), ucfirst($this->getName()));
                $permissions->registerPermission('Update' . $entity->getEntityName(), 'Update '.ucfirst($entity->getNiceName()), ucfirst($this->getName()));
                $permissions->registerPermission('Create' . $entity->getEntityName(), 'Create '.ucfirst($entity->getNiceName()), ucfirst($this->getName()));
                $permissions->registerPermission('Delete' . $entity->getEntityName(), 'Delete '.ucfirst($entity->getNiceName()), ucfirst($this->getName()));
            }
        }
    }
}
